<?php

// click stats per url
require_once dirname(__FILE__).'/accesscheck.php';

if (isset($_GET['id'])) {
    $id = sprintf('%d', $_GET['id']);
} else {
    $id = 0;
}

$some = 0;
$access = accessLevel('uclicks');
switch ($access) {
    case 'owner':
        $select_tables = $GLOBALS['tables']['linktrack_ml'].' as ml, '.$GLOBALS['tables']['message'].' as message, '.$GLOBALS['tables']['linktrack_forward'].' as forward ';
        $owner_and = ' and message.id = ml.messageid and message.owner = '.$_SESSION['logindetails']['id'];
        break;
    case 'all':
        $select_tables = $GLOBALS['tables']['linktrack_ml'].' as ml, '.$GLOBALS['tables']['linktrack_forward'].' as forward ';
        $owner_and = '';
        break;
        break;
    case 'none':
    default:
        print $GLOBALS['I18N']->get('You do not have access to this page');

        return;
        break;
}

$download = !empty($_GET['dl']);
if ($download) {
    ob_end_clean();
//  header("Content-type: text/plain");
    header('Content-type: text/csv');
    if (!$id) {
        header('Content-disposition:  attachment; filename="phpList URL click statistics.csv"');
    }
    ob_start();
}

if (!$id) {
    $req = Sql_Query(sprintf('
        SELECT forward.id,
        url,
        SUM(clicked) AS numclicks,
        MAX(latestclick) AS lastclicked,
        COUNT(messageid) AS msgs
        FROM %s
        WHERE clicked %s AND forward.id = ml.forwardid AND latestclick > DATE_SUB(NOW(),INTERVAL 12 MONTH)
        GROUP BY forward.id
        ORDER BY lastclicked DESC
        LIMIT 50',
        $select_tables, $owner_and));
    $ls = new WebblerListing($GLOBALS['I18N']->get('Available URLs'));
    while ($row = Sql_Fetch_Array($req)) {
        $some = 1;
        if (!$download) {
            $element = shortenTextDisplay($row['url'], 30);
        } else {
            $element = $row['url'];
        }
        $ls->addElement($element, PageURL2('uclicks&amp;id='.$row['id']));
        $ls->addColumn($element, $GLOBALS['I18N']->get('msgs'), $row['msgs']);
        $ls->addColumn($element, $GLOBALS['I18N']->get('last clicked'), formatDateTime($row['lastclicked'], 1));
        $ls->addColumn($element, $GLOBALS['I18N']->get('clicks'), $row['numclicks']);
    }
    if ($download) {
        ob_end_clean();
        echo $ls->tabDelimited();
    }
    if ($some) {
        echo '<p>'.$GLOBALS['I18N']->get('Select URL to view').'</p>';
        echo '<div class="actions pull-right">'.PageLinkButton('uclicks&dl=true',
                $GLOBALS['I18N']->get('Download as CSV file')).'</div><div class="clearfix"></div>';
        echo $ls->display();
    } else {
        echo '<p class="information">'.$GLOBALS['I18N']->get('There are currently no statistics available').'</p>';
    }

    return;
}

echo '<div class="actions">'.PageLinkButton('uclicks&dl=true&id='.$id,
        $GLOBALS['I18N']->get('Download as CSV file')).'</div>';

$ls = new WebblerListing($GLOBALS['I18N']->get('URL Click Statistics'));

$urldata = Sql_Fetch_Array_Query(sprintf('select url from %s where id = %d',
    $GLOBALS['tables']['linktrack_forward'], $id));
echo '<h3>'.$GLOBALS['I18N']->get('Click details for a URL').' <b>'.$urldata['url'].'</b></h3><br/>';
echo PageLinkButton('userclicks&fwdid='.$id, s('View subscribers'));
if ($download) {
    header('Content-disposition:  attachment; filename="phpList URL click statistics for '.$urldata['url'].'.csv"');
}
$req = Sql_Query(sprintf('select messageid,firstclick,date_format(latestclick,
  "%%e %%b %%Y %%H:%%i") as latestclick,total,clicked from %s where forwardid = %d and firstclick is not null order by firstclick desc
  ', $GLOBALS['tables']['linktrack_ml'], $id));
$summary = array();
$summary['totalsent'] = 0;
$summary['totalclicks'] = 0;
$summary['uniqueclicks'] = 0;

while ($row = Sql_Fetch_Array($req)) {
    $messagedata = loadMessageData($row['messageid']);
    if (!$download) {
        if ($messagedata['subject'] != $messagedata['campaigntitle']) {
            $element = '<!--'.$row['messageid'].'-->'.stripslashes($messagedata['campaigntitle']).'<br/><strong>'.shortenTextDisplay($messagedata['subject'],
                    30).'</strong>';
        } else {
            $element = '<!--'.$row['messageid'].'-->'.shortenTextDisplay($messagedata['subject'], 30);
        }
    } else {
        $element = $messagedata['subject'];
    }
//  $element = $GLOBALS['I18N']->get('msg').' '.$row['messageid'].': '.substr($msgsubj[0],0,25). '...';
//  $element = sprintf('<a href="%s" target="_blank" class="url" title="%s">%s</a>',$row['url'],$row['url'],substr(str_replace('http://','',$row['url']),0,50));
//  $total = Sql_Verbose_Query(sprintf('select count(*) as total from %s where messageid = %d and url = "%s"',
//    $GLOBALS['tables']['linktrack'],$id,$row['url']));

    // if (CLICKTRACK_SHOWDETAIL) {
    $uniqueclicks = Sql_Fetch_Array_Query(sprintf('select count(distinct userid) as users from %s
      where messageid = %d and forwardid = %d',
        $GLOBALS['tables']['linktrack_uml_click'], $row['messageid'], $id));
//  }

    $ls->addElement($element, PageUrl2('mclicks&amp;id='.$row['messageid']));
    $ls->setClass($element, 'row1');
    $ls->addColumn($element, $GLOBALS['I18N']->get('firstclick'), formatDateTime($row['firstclick'], 1));
    $ls->addColumn($element, $GLOBALS['I18N']->get('latestclick'), $row['latestclick']);
    $ls->addRow($element,
        '<div class="listingsmall gray">'.$GLOBALS['I18N']->get('sent').': '.$row['total'].'</div>', '');
//  $ls->addColumn($element,$GLOBALS['I18N']->get('clicks'),$row['clicked'].'<span class="viewusers"><a class="button" href="'.PageUrl2('userclicks&amp;msgid='.$row['messageid'].'&amp;fwdid='.$id.'" title="'.$GLOBALS['I18N']->get('view users').'"></a></span>'));
//  $perc = sprintf('%0.2f',($row['clicked'] / $row['total'] * 100));
// $ls->addColumn($element,$GLOBALS['I18N']->get('clickrate'),$perc.'%');
    $summary['totalsent'] += $row['total'];
//  if (CLICKTRACK_SHOWDETAIL) {
    $ls->addColumn($element, $GLOBALS['I18N']->get('clicks'),
        $uniqueclicks['users'].'<span class="viewusers"><a class="button" href="'.PageUrl2('userclicks&amp;msgid='.$row['messageid'].'&amp;fwdid='.$id).'" title="'.s('view subscribers who clicked').'"></a></span>');
    $perc = sprintf('%0.2f', ($uniqueclicks['users'] / $row['total'] * 100));
    $ls->addColumn($element, $GLOBALS['I18N']->get('click rate'), $perc.'%');
    $summary['uniqueclicks'] += $uniqueclicks['users'];
//  }
    $summary['totalclicks'] += $row['clicked'];
}
$ls->addElement($GLOBALS['I18N']->get('total'));
$ls->setClass($GLOBALS['I18N']->get('total'), 'rowtotal');
//$ls->addColumn($GLOBALS['I18N']->get('total'),$GLOBALS['I18N']->get('clicks'),$summary['totalclicks']);
//$perc = sprintf('%0.2f',($summary['totalclicks'] / $summary['totalsent'] * 100));
//$ls->addColumn($GLOBALS['I18N']->get('total'),$GLOBALS['I18N']->get('clickrate'),$perc.'%');
//if (CLICKTRACK_SHOWDETAIL) {
$ls->addColumn($GLOBALS['I18N']->get('total'), $GLOBALS['I18N']->get('clicks'), $summary['uniqueclicks']);
$perc = sprintf('%0.2f', ($summary['uniqueclicks'] / $summary['totalsent'] * 100));
$ls->addColumn($GLOBALS['I18N']->get('total'), $GLOBALS['I18N']->get('click rate'), $perc.'%');
//}
echo $ls->display();
if ($download) {
    ob_end_clean();
    echo $ls->tabDelimited();
}
