<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'es', branch 'MOODLE_35_STABLE'
 *
 * @package   theme_adaptable
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actingasrole'] = 'Actualmente está actuando con un rol diferente';
$string['activebreadcrumb'] = 'Color de fondo de la ruta de navegación activa';
$string['activebreadcrumbdesc'] = 'Establece el color de fondo de la ruta de navegación activa.';
$string['alertaccess'] = 'Visibilidad de la Alerta';
$string['alertaccessadmins'] = 'Visible para administradores';
$string['alertaccessdesc'] = 'Establece la visibilidad de la Alerta según su tipo. Nota: Si se usa "Añadir restricción por campo personalizado" necesitrás añadir el campo personalizado de usuario.';
$string['alertaccessglobal'] = 'Visible para todo el mundo';
$string['alertaccessprofile'] = 'Añadir restricción por campo personalizado';
$string['alertaccessusers'] = 'Visible para usuarios';
$string['alertannounce'] = 'Anuncio';
$string['alertannouncedesc'] = 'Muestra un anuncio en la zona de alerta.';
$string['alertbackgroundcolorinfo'] = 'Color de fondo de la información';
$string['alertbackgroundcolorinfodesc'] = 'Color de fondo de los cuadros de información';
$string['alertbackgroundcolorsuccess'] = 'Color de fondo del aviso';
$string['alertbackgroundcolorsuccessdesc'] = 'Color de fondo de los cuadros de avisos';
$string['alertbackgroundcolorwarning'] = 'Color de fondo de la advertencia';
$string['alertbackgroundcolorwarningdesc'] = 'Color de fondo de los cuadros de advertencia';
$string['alertbordercolorinfo'] = 'Color del borde';
$string['alertbordercolorinfodesc'] = 'Color de borde de los cuadros de alerta';
$string['alertbordercolorsuccess'] = 'Color de borde de los avisos';
$string['alertbordercolorsuccessdesc'] = 'Color de borde de los cuadros de avisos';
$string['alertbordercolorwarning'] = 'Color de borde de la advertencia';
$string['alertbordercolorwarningdesc'] = 'Color de borde de los cuadros de advertencia';
$string['alertcolorinfo'] = 'Color de información';
$string['alertcolorinfodesc'] = 'Color del icono de los cuadros de información';
$string['alertcolorsheading'] = 'Personalizar los cuadros de alerta superiores';
$string['alertcolorsheadingdesc'] = 'Establecer colores e iconos.';
$string['alertcolorsuccess'] = 'Color del aviso';
$string['alertcolorsuccessdesc'] = 'Color del icono de los cuadros de avisos';
$string['alertcolorwarning'] = 'Color de advertencia';
$string['alertcolorwarningdesc'] = 'Color del icono de los cuadros de advertencia';
$string['alertcount'] = 'Contador de Alertas';
$string['alertcountdesc'] = 'Número de alertas a crear a continuación.';
$string['alertdesc'] = 'Introduce y personaliza el texto de las Alertas mostradas en la parte superior de la pantalla. Es posible crear más de una para mostrarse a diferentes tipos de usuarios. También existe la opción de mostrar las alertas en la página inicial y en las páginas de los cursos.';
$string['alertdisabled'] = 'Desactivado';
$string['alertdisabledesc'] = 'Desactivar esta alerta.';
$string['alerthiddencourse'] = 'Advertencia de curso oculto';
$string['alerthiddencoursedesc'] = 'Mostrar una alerta en la página del curso si este está oculto';
$string['alerthiddencoursetext-1'] = 'Este curso está oculto y los estudiantes no pueden acceder a él.';
$string['alerthiddencoursetext-2'] = 'Haga clic aquí para actualizar la configuración';
$string['alerticoninfo'] = 'Icono de información';
$string['alerticoninfodesc'] = 'Establecer los<a href="http://fortawesome.github.io/Font-Awesome/icons/"> Iconos de Font Awesome</a> que serán utilizados en los cuadros de información. Introduzca el nombre del icono sin el prefijo fa-.';
$string['alerticonsuccess'] = 'Icono de aviso';
$string['alerticonsuccessdesc'] = 'Establecer los<a href="http://fortawesome.github.io/Font-Awesome/icons/"> Iconos de Font Awesome</a> que serán utilizados en los cuadros de aviso de. Introduzca el nombre del icono sin el prefijo fa-.';
$string['alerticonwarning'] = 'Icono de advertencia';
$string['alerticonwarningdesc'] = 'Establecer los<a href="http://fortawesome.github.io/Font-Awesome/icons/"> Iconos de Font Awesome</a> que serán utilizados en los cuadros de advertencia. Introduzca el nombre del icono sin el prefijo fa-.';
$string['alertinfo'] = 'Info';
$string['alertinfodesc'] = 'Muestra información en la zona de alerta.';
$string['alertkeyvalue'] = 'Clave de identificación de la Alerta';
$string['alertkeyvalue_details'] = 'Esta clave identifica la alerta y permite el control de la eliminación de la alerta en la pantalla por parte del usuario. Si se cambia la clave, los usuarios volverán a ver la alerta de nuevo.';
$string['alertprofilefield'] = 'Campo de usuario personalizado Nombre=Valor (opcional)';
$string['alertprofilefielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: "usertype=alumno"';
$string['alertsettings'] = 'Alerta {$a}';
$string['alertsettingscourse'] = 'Configuración de las alertas del curso';
$string['alertsettingsgeneral'] = 'Configuración Alertas';
$string['alertsettingsheading'] = 'Personalizar las Alertas';
$string['alerttext'] = 'Texto de la Alerta';
$string['alerttextdesc'] = 'Introduce el texto a mostrar en la alerta.';
$string['alerttype'] = 'Tipo de Alerta';
$string['alerttypedesc'] = 'Selecciona el tipo de alerta: info (azul), aviso (amarillo) o anuncio (verde)';
$string['alertwarning'] = 'Aviso';
$string['alertwarningdesc'] = 'Muestra un aviso en la zona de alerta.';
$string['analyticscount'] = 'Número de campos de perfil';
$string['analyticscountdesc'] = 'Número de campos personalizados a introducir en el área inferior.';
$string['analyticsprofilefield'] = 'Nombre del campo personalizado del perfíl Field Name=Value (opcional)';
$string['analyticsprofilefielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: usertype=alumno';
$string['analyticssettings'] = 'Analítica Web';
$string['analyticssettingsdesc'] = 'Puedes configurar múltiples códigos para Google Analytics y enlazarlos con diversos campos personalizados.';
$string['analyticssettingsheading'] = 'Configurar Google Analytics';
$string['analyticstext'] = 'Analytics ID';
$string['analyticstextdesc'] = 'Introducir la ID de Google Analytics.';
$string['backcolor'] = 'Color de fondo';
$string['backcolordesc'] = 'Establece el color de fondo de la plantilla.';
$string['bcustyle'] = 'Estilo BCU';
$string['beta'] = 'VERSIÓN EN DESARROLLO. NO USAR EN SITIOS EN PRODUCCIÓN';
$string['blockbackgroundcolor'] = 'Color de fondo de los bloques';
$string['blockbackgroundcolordesc'] = 'Establece el color de fondo de los bloques.';
$string['blockbordercolor'] = 'Color del borde de los bloques';
$string['blockbordercolordesc'] = 'Establece el color del borde de los bloques.';
$string['blockheaderbackgroundcolor'] = 'Color del texto de los encabezados de los bloques';
$string['blockheaderbackgroundcolordesc'] = 'Establece el color del texto de los encabezados de los bloques.';
$string['blockheaderborderbottom'] = 'Grueso del borde inferior de los bloques';
$string['blockheaderborderbottomdesc'] = 'Establece el grosor del borde inferior de los bloques.';
$string['blockheaderborderleft'] = 'Grueso del borde izquierdo de los bloques';
$string['blockheaderborderleftdesc'] = 'Establece el grosor del borde izquierdo de los bloques.';
$string['blockheaderborderright'] = 'Grueso del borde derecho de los bloques';
$string['blockheaderborderrightdesc'] = 'Establece el grosor del borde derecho de los bloques.';
$string['blockheaderbordertop'] = 'Grueso del borde superior de los bloques';
$string['blockheaderbordertopdesc'] = 'Establece el grosor del borde superior de los bloques.';
$string['blockheaderbordertopstyle'] = 'Estilo del borde de los bloques';
$string['blockheaderbordertopstyledesc'] = 'Establece el estilo del borde de los bloques laterales.';
$string['blockheaderbottomradius'] = 'Radio de las esquinas inferiores de los bloques laterales';
$string['blockheaderbottomradiusdesc'] = 'Radio de las esquinas inferiores de los bloques laterales. Valor más alto es igual a efecto redondeado.';
$string['blockheadercolor'] = 'Color de fondo de la cabecera de los bloques';
$string['blockheadercolordesc'] = 'Establece el color de fondo de la cabecera de los bloques.';
$string['blockheadertopradius'] = 'Radio de las esquinas superiores de los bloques laterales';
$string['blockheadertopradiusdesc'] = 'Radio de las esquinas superiores de los bloques laterales. Valor más alto es igual a efecto redondeado.';
$string['blockicons'] = 'Mostrar iconos en los bloques';
$string['blockiconsdesc'] = 'Mostrar / Ocultar un icono relacionado con el tipo de bloque al lado del encabezamiento.';
$string['blocklayoutbuilder'] = 'Creador de regiones para bloques';
$string['blocklayoutbuilderdesc'] = 'A continuación puedes crear tu propia distribución de regiones para los bloques de moodle en la página principal.
Para añadir contenido a estas regiones necesitarás <strong>Activar edición en la página principal de Moodle</strong>.
Entonces podrás arrastras y soltar los bloques en las regiones creadas.';
$string['blocklayoutlayoutcheck'] = 'Comprueba la distribución';
$string['blocklayoutlayoutcheckdesc'] = 'Utiliza esta opción para ver la distribución creada y comprobar el número de bloques que has utilizado.';
$string['blocklayoutlayoutcount1'] = 'Puedes crear un máximo de';
$string['blocklayoutlayoutcount2'] = 'regiones para bloques. Ahora estás usando:';
$string['blocklayoutlayoutrow'] = 'Filas de regiones para bloques';
$string['blocklayoutlayoutrowdesc'] = 'Añade / establece la distribución de filas de las regiones para bloques de la página principal.';
$string['blockmainborderbottom'] = 'Grueso del borde inferior del bloque central';
$string['blockmainborderbottomdesc'] = 'Establece el grosor del borde inferior del bloque central.';
$string['blockmainborderleft'] = 'Grueso del borde izquierdo del bloque central';
$string['blockmainborderleftdesc'] = 'Establece el grosor del borde izquierdo del bloque central.';
$string['blockmainborderright'] = 'Grueso del borde derecho del bloque central';
$string['blockmainborderrightdesc'] = 'Establece el grosor del borde derecho del bloque central.';
$string['blockmainbordertop'] = 'Grueso del borde superior del bloque central';
$string['blockmainbordertopdesc'] = 'Establece el grosor del borde superior del bloque central.';
$string['blockmainbordertopstyle'] = 'Estilo del borde del bloque central';
$string['blockmainbordertopstyledesc'] = 'Establece el estilo del borde de los bloques centrales.';
$string['blockmainbottomradius'] = 'Radio de las esquinas inferiores de los bloques centrales';
$string['blockmainbottomradiusdesc'] = 'Radio de las esquinas inferiores de los bloques centrales. Valor más alto es igual a efecto redondeado.';
$string['blockmaintopradius'] = 'Radio de las esquinas superiores de los bloques centrales';
$string['blockmaintopradiusdesc'] = 'Radio de las esquinas superiores de los bloques centrales. Valor más alto es igual a efecto redondeado.';
$string['blockregionbackground'] = 'Color de fondo de las regiones para bloques';
$string['blockregionbackgrounddesc'] = 'Establece el color de fondo del contenedor del constructor de bloques de la página principal.';
$string['blocksettings'] = 'Bloques';
$string['blockside'] = 'Posición de los bloques';
$string['blocksidedesc'] = 'Mostrar los bloques en la columna derecha o izquierda.';
$string['breadcrumb'] = 'Color de fondo de la ruta de navegación';
$string['breadcrumbdesc'] = 'Establece el color de fondo de la ruta de navegación.';
$string['breadcrumbhome'] = 'Inicio de la ruta de navegación';
$string['breadcrumbhomedesc'] = 'Muestra el inicio de la ruta de navegación como icono o como texto.';
$string['breadcrumbhomeicon'] = 'Icono';
$string['breadcrumbhometext'] = 'Texto';
$string['breadcrumbseparator'] = 'Separador de la ruta de navegación';
$string['breadcrumbseparatordesc'] = 'Establece el icono de  <a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Font Awesome Icon</a> para ser usado como separador de los elementos de laruta de navegación. Introducir el nombre del icono sin el prefijo fa-.';
$string['breadcrumbtextcolor'] = 'Color del texto de la ruta de navegación';
$string['breadcrumbtextcolordesc'] = 'Establece el color del texto de la ruta de navegación.';
$string['breadcrumbtitle'] = 'Nombre del curso en la guía de exploración';
$string['breadcrumbtitledesc'] = 'Establece el modo de visualización del título del curso en la guía de exploración.';
$string['breadcrumbtitlefullname'] = 'Nombre completo del curso';
$string['breadcrumbtitleshortname'] = 'Nombre corto del curso / Código';
$string['buttoncolor'] = 'Colores de los botones';
$string['buttoncolordesc'] = 'El color de los botones principales.';
$string['buttondesc'] = 'personaliza a forma y colores de los botones utilizados en la plantilla.';
$string['buttonhovercolor'] = 'Color Hover de los botones';
$string['buttonhovercolordesc'] = 'Color del botón al pasar el cursor por encima.';
$string['buttonlogincolor'] = 'Color del botón Entrar';
$string['buttonlogincolordesc'] = 'Color del botón Entrar.';
$string['buttonloginheight'] = 'Altura del botón Entrar';
$string['buttonloginheightdesc'] = 'Altura del botón Entrar. Solo si se utiliza el formulario de entrada en la cabecera.';
$string['buttonloginhovercolor'] = 'Color Hover del botón Entrar';
$string['buttonloginhovercolordesc'] = 'Color del botón Entrar al pasar el cursos por encima.';
$string['buttonloginmargintop'] = 'Margen superior del botón Entrar';
$string['buttonloginmargintopdesc'] = 'Permite posicionar el botón Entrar si se han cambiado los valores indicados anteriormente.';
$string['buttonloginpadding'] = 'Separación del texto del botón Entrar';
$string['buttonloginpaddingdesc'] = 'Separación alrededor del texto del botón Entrar. Número más alto = Botón más grande.';
$string['buttonlogintextcolor'] = 'Color del texto del botón Entrar';
$string['buttonlogintextcolordesc'] = 'Color del texto del botón Entrar.';
$string['buttonradius'] = 'Radio de las esquinas';
$string['buttonradiusdesc'] = '0 = esquinas cuadradas. Un valor más alto es igual a esquinas más redondeadas.';
$string['buttonsettings'] = 'Botones';
$string['buttonsettingsheading'] = 'Personalizar los botones.';
$string['buttontextcolor'] = 'Color del texto de los botones';
$string['buttontextcolordesc'] = 'Color del texto de los botones.';
$string['cachedef_userdata'] = 'El tiempo para guardar una sesión de un usuario específico.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
 <h2>Adaptable</h2>
 <p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
</div>
<div class="well">
 <h2>Créditos</h2>
 <h3>Acerca de...</h3>
 <p>Adaptable es una plantilla para Moodle, de dos columnas y tipo responsive, altamente personalizable y basada en la popular plantilla BCU.</p>
 <p>Esta plantilla está bajo licencia GPL (GNU General Public License). Puedes encontrar la licencia completa en: <a href="http://www.gnu.org/licenses/">http://www.gnu.org/licenses</a></p>
 <p>Modifícala / Mejórala / Compártela</p>
 <br>
 <p>Esta plantilla ha sido creada por:<br>
 Jeremy Hopkins (Coventry University)<br>
 Fernando Acedo (3-bits.com)<br>
 </p>
 <br>
 <h3>Informar de errores</h3>
 <p>Puedes informar de errores encontrados en esta plantilla a través del foro de moodle o en https://bitbucket.org/covuni/moodle-theme_adaptable/issues</p>
 <br>
 <h3>Documentación</h3>
 <br>
 <br>
 <h3>Demo</h3>
 <p>Puedes ver una demostración del sitio y descargar un archivo de instalación en <a href="http://3-bits.com/demo/adaptable">http://3-bits.com/demo/adaptable</a></p>
 <br>
<p>Traducción es-ES: Fernando Acedo (3-bits.com)</p>
</div>
</div>';
$string['colordesc'] = 'Puedes seleccionar los colores que desees para ser usados por la plantilla. Usa la notación HEX estándar. También puedes usar como valores <i>transparent</i> e <i>inherited.</i>';
$string['colorsettings'] = 'Colores';
$string['colorsettingsheading'] = 'Modifica los principales colores utilizados en la plantilla.';
$string['configtitle'] = 'Adaptable';
$string['course'] = 'Curso';
$string['coursepagenewssliderblockregionheadingdesc'] = 'Una región de bloque personalizada diseñada para usar con el control deslizante de noticias que forma parte de la IU Adaptable. Esta región aparece encima de las actividades del curso en una página del curso. Para agregar un bloque deslizante de noticias, primero instale el <strong> <a href="https://moodle.org/plugins/block_news_slider"> control deslizante de noticias de UI adaptable </a> </ strong> y configúrelo para que aparezca en la región "región del deslizador de la página del curso" en todas las páginas del curso.';
$string['coursesectionactivityuseadaptableicons'] = 'Usar conjunto de iconos del tema "Adaptable"';
$string['coursesectionactivityuseadaptableiconsdesc'] = 'Active esto para usar iconos del tema Adaptable. Si está desactivado, asegúrese de eliminar los directorios adaptable/pix_plugins y adaptable/pix_core/fpara usar los iconos predeterminados de Moodle.';
$string['coursesectionbordercolor'] = 'Color del borde de la sección';
$string['coursesectionbordercolordesc'] = 'Establece el color del borde de la sección del curso.';
$string['coursesectionborderradius'] = 'Radio del borde de la sección';
$string['coursesectionborderradiusdesc'] = 'Establece el radio del borde de las esquinas de la sección del curso.';
$string['coursesectionborderstyle'] = 'Estilo del borde de la sección del curso';
$string['coursesectionborderstyledesc'] = 'Establece el estilo del borde de la sección del curso.';
$string['coursesectionborderwidth'] = 'Grueso del borde de la sección';
$string['coursesectionborderwidthdesc'] = 'Establece el grueso del borde de la sección del curso.';
$string['coursesectionheaderbg'] = 'Color de fondo de la cabecera';
$string['coursesectionheaderbgdesc'] = 'Establece el color de fondo de la cabecera de la sección del curso.';
$string['coursesectionheaderbordercolor'] = 'Color del borde inferior de la cabecera';
$string['coursesectionheaderbordercolordesc'] = 'Establece el color del borde inferior de la cabecera de la sección del curso.';
$string['coursesectionheaderborderradiusbottom'] = 'Radio de las esquinas del borde inferior de la cabecera';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Establece el radio de las esquinas del borde inferior de la cabecera de la sección del curso.';
$string['coursesectionheaderborderradiustop'] = 'Radio de las esquinas del borde superior de la cabecera';
$string['coursesectionheaderborderradiustopdesc'] = 'Establece el radio de las esquinas del borde superior de la cabecera de la sección del curso.';
$string['coursesectionheaderborderstyle'] = 'Estilo del borde inferior de la cabecera';
$string['coursesectionheaderborderstyledesc'] = 'Establece el estilo del borde inferior de la cabecera de la sección del curso.';
$string['coursesectionheaderborderwidth'] = 'Grueso del borde inferior de la cabecera';
$string['coursesectionheaderborderwidthdesc'] = 'Establece el grueso del borde inferior de la cabecera de la sección del curso.';
$string['coursesettings'] = 'Secciones del curso';
$string['coursesettingsdesc'] = 'Personalice algunos de los formatos de curso más utilizados en Moodle para adaptarlos al diseño principal.';
$string['coursesettingsheading'] = 'Configuración de las secciones del curso.';
$string['coursetitlemaxwidth'] = 'Ancho máximo del título del curso';
$string['coursetitlemaxwidthdesc'] = 'Establece el ancho máximo del área donde se muestra el título del curso.';
$string['coursetitlepaddingleft'] = 'Separación izquierda del título del curso';
$string['coursetitlepaddingleftdesc'] = 'Permite ajustar la separación, en píxeles, de la parte izquierda del título del curso.';
$string['coursetitlepaddingtop'] = 'Separación superior del título del curso';
$string['coursetitlepaddingtopdesc'] = 'Permite ajustar la separación, en píxeles, de la parte superior del título del curso.';
$string['covbkcolor'] = 'Color de fondo en los bloques estilo Coventry';
$string['covbkcolordesc'] = 'Establece el color de superposición de los bloques cuando se ha seleccionado el estilo Coventry.';
$string['coventrystyle'] = 'Estilo Coventry';
$string['covfontcolor'] = 'Color del texto en los bloques estilo Coventry';
$string['covfontcolordesc'] = 'Establece el color del texto en los bloques estilo Coventry.';
$string['covhidebutton'] = 'Mostrar el botón del curso en los bloques estilo Coventry';
$string['covhidebuttondesc'] = 'Mostrar / ocultar el botón del curso cuando se utiliza el estilo Coventry.';
$string['currentcolor'] = 'Color de realce de la sección actual';
$string['currentcolordesc'] = 'Establece el color de realce de la sección actual.';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Introduce las reglas CSS personalizadas.';
$string['customcssjssettings'] = 'CSS y JS personalizado';
$string['dashblocklayoutbuilder'] = 'Region de Bloques del Tablero de Control';
$string['dashblocklayoutbuilderdesc'] = 'A continuación podrá crear su propio diseño para las regiones de bloques en el tablero de control.
Para agregar contenido a estas regiones necesitará <strong> activar la edición de la página en el panel de control de Moodle. <strong> ¡Entonces podrá comenzar a arrastrar/soltar bloques en las regiones que cree!';
$string['dashblocklayoutlayoutrow'] = 'Fila del tablero de control';
$string['dashblocklayoutlayoutrowdesc'] = 'Agregar/establecer el diseño para la fila de bloques en el tablero de control.';
$string['dashblocksenabled'] = 'Habilitar regiones de bloques personalizadas en el tablero de control.';
$string['dashblocksenableddesc'] = 'Puede habilitar/deshabilitar las regiones de bloques personalizadas en el tablero de control.
A continuación podrá arrastrar y soltar bloques en las regiones que ha creado.';
$string['dashboardblockregionsettings'] = 'Constructor de regiones de bloques en el tablero de control';
$string['deprecated'] = 'VERSIÓN DESACTUALIZADA DE MOODLE. NO PUEDE USAR EL TEMA ADAPTABLE EN ESTE SITIO';
$string['disablecustommenu'] = 'Desactivar el menú personalizado de Moodle';
$string['disablecustommenudesc'] = 'Desactiva el menú personalizado de Moodle en la barra de navegación (seguirá funcionando en otras plantillas instaladas)';
$string['disablemenuscoursepages'] = 'Desactivar menús en las páginas de los cursos';
$string['disablemenuscoursepagesdesc'] = 'Activando esta opción los menús solo se mostrarán en las páginas del sitio, la página inicial, el Área Personal, etc. y no se mostrará en las páginas de los cursos.';
$string['displaylogin'] = 'Mostrar';
$string['displayloginbox'] = 'Caja de entrada';
$string['displayloginbutton'] = 'Botón';
$string['displaylogindesc'] = 'Selecciona como mostrar la caja de entrada en la pantalla (cuando se activa aqui abajo)';
$string['displayloginno'] = 'Sin entrada';
$string['dividingline'] = 'Línea divisora de la cabecera';
$string['dividingline2'] = 'Línea divisora del pie de página';
$string['dividingline2desc'] = 'Establece el color de la línea divisora del pie de página.';
$string['dividinglinedesc'] = 'Establece el color de la línea divisora de la cabecera.';
$string['editfont'] = 'Color del texto de los botones de <i>Edición</i> y <i>Personalizar esta página</i>';
$string['editfontdesc'] = 'establece el color del texto de los botones de <i>Edición</i> y <i>Personalizar esta página</i>';
$string['edithorizontalpadding'] = 'Espaciado horizontal de los botones de edición';
$string['editoffbk'] = 'Color de fondo de los botones de edición y personalización desactivados';
$string['editoffbkdesc'] = 'Establece el color de fondo de los botones de edición y personalización cuando están desactivados.';
$string['editonbk'] = 'Color de fondo de los botones de edición y personalización activados';
$string['editonbkdesc'] = 'Establece el color de fondo de los botones de edición y personalización cuando están activados.';
$string['edittopmargin'] = 'Margen superior de los botones de edición';
$string['editverticalpadding'] = 'Espaciado vertical de los botones de edición';
$string['emoticonsize'] = 'Tamaño del emoticono';
$string['emoticonsizedesc'] = 'Establece el ancho y alto de los emoticonos de moodle.';
$string['enablealert'] = 'Activar Alerta {$a}';
$string['enablealertcoursepages'] = 'Activar Alertas en las páginas de los cursos';
$string['enablealertcoursepagesdesc'] = 'Activar las alertas también en las páginas de los cursos.';
$string['enablealertdesc'] = 'Activar la alerta {$a}.';
$string['enablealerts'] = 'Activar / Desactivar Alertas';
$string['enablealertsdesc'] = 'Activar / desactivar alertas en el sitio.';
$string['enablealertstriptags'] = 'Eliminar etiquetas HTML del texto de la Alerta';
$string['enablealertstriptagsdesc'] = 'Si se activa, se eliminarán las etiquetas HTML del texto. Si está desactivado, se permitirá introducir etiquetas HTML por ejemplo para añadir enlaces.';
$string['enableanalytics'] = 'Activar Google Analytics';
$string['enableanalyticsdesc'] = 'Activar Google Analytics en el sitio.';
$string['enableavailablecourses'] = 'Mostrar el texto "Cursos Disponibles"';
$string['enableavailablecoursesdesc'] = 'Mostrar el texto <i>Cursos Disponibles</i> sobre el listado de cursos en la página inicial.';
$string['enablebadges'] = 'Insignias';
$string['enablebadgesdesc'] = 'Mostrar el enlace de las insignias del usuario.';
$string['enableblog'] = 'Blogs del usuario';
$string['enableblogdesc'] = 'Mostrar el enlace a los blogs del usuario.';
$string['enablecalendar'] = 'Calendario';
$string['enablecalendardesc'] = 'Mostrar el enlace al calendario del usuario.';
$string['enableeditprofile'] = 'Editar perfil';
$string['enableeditprofiledesc'] = 'Mostrar el enlace para editar el perfil del usuario.';
$string['enableeventsdesc'] = 'Mostrar un enlace al calendario';
$string['enablefeed'] = 'Mis opiniones';
$string['enablefeeddesc'] = 'Mostrar el enlace a la página "Opiniones" - Nota: esta opción requiere el <a href="https://moodle.org/plugins/report_myfeedback" target="blank">plugin My Feedback</a> instalado';
$string['enablegrades'] = 'Calificaciones';
$string['enablegradesdesc'] = 'Mostrar el enlace de las calificaciones del usuario.';
$string['enableheading'] = 'Mostrar nombre del curso';
$string['enableheadingdesc'] = 'Establece el modo de visualización del título del curso en la cabecera.';
$string['enablehelp'] = 'Enlace de ayuda';
$string['enablehelpdesc'] = 'Añade un enlace de ayuda en la barra de navegación.';
$string['enablehomedesc'] = 'Mostrar enlace a Inicio';
$string['enablehomeredirect'] = 'Activar redirect=0';
$string['enablehomeredirectdesc'] = 'Activa la opción redirect=0 para redirigir a la página inicial del sitio. Está opción puede utilizarse en sitios que tienen el Área Personal como página inicial por defecto. Desactivada previene redirigir a los usuarios a la página inicial y ser redirigidos al Área Personal';
$string['enablemenus'] = 'Activar Menús';
$string['enablemenusdesc'] = 'Por motivos de rendimiento, se recomienda no activarlo si no se utilizan los menús.';
$string['enablemessagemenu'] = 'Menú mensajes';
$string['enablemessagemenudesc'] = 'Activa el menú Mensajes';
$string['enablemy'] = 'Inicio';
$string['enablemydesc'] = 'Mostrar el enlace a Inicio';
$string['enablemyhomedesc'] = 'Mostrar un enlace a {$a}';
$string['enablemysitesdesc'] = 'Mostrar las actividades del curso';
$string['enablenote'] = 'Notificaciones';
$string['enablenotedesc'] = 'Mostrar el enlace página de notificaciones.';
$string['enableposts'] = 'Mis entradas';
$string['enablepostsdesc'] = 'Mostrar el enlace a las entradas en los foros realizadas por el usuario.';
$string['enablepref'] = 'Preferencias';
$string['enableprefdesc'] = 'Mostrar el enlace a las preferencias del usuario.';
$string['enableprivatefiles'] = 'Archivos privados';
$string['enableprivatefilesdesc'] = 'Mostrar el enlace a los archivos privados del usuario.';
$string['enableprofile'] = 'Perfil usuario';
$string['enableprofiledesc'] = 'Mostrar el enlace del perfil de usuario.';
$string['enablesearchbox'] = 'Activar cuadro de búsqueda';
$string['enablesearchboxdesc'] = 'Mostrar el cuadro de búsqueda en la parte superior de la pantalla.';
$string['enableshowhideblocks'] = 'Activar Mostrar/Ocultar bloques';
$string['enableshowhideblocksdesc'] = 'Permite a los usuarios mostrar / ocultar los bloques laterales.';
$string['enablethiscoursedesc'] = 'Mostrar un desplegable con las actividades del curso.';
$string['enableticker'] = 'Mostrar los anuncios en la página principal';
$string['enabletickerc'] = 'Mostrar la barra de anuncios en las páginas internas';
$string['enabletickercdesc'] = 'Muestra la barra de anuncios en las páginas internas de moodle.';
$string['enabletickerdesc'] = 'Muestra la barra de anuncios en la página principal.';
$string['enabletickermy'] = 'Mostrar la barra de anuncios en Mi Área personal / Panel de control';
$string['enabletickermydesc'] = 'Muestra la barra de anuncios en Mi Área personal / Panel de control.';
$string['enabletoolsmenus'] = 'Activar menús de herramientas';
$string['enabletoolsmenusdesc'] = 'Por razones de rendimiento se recomienda dejarlo desactivado si no se utilizan.';
$string['enablezoom'] = 'Activar Zoom';
$string['enablezoomdesc'] = 'Permite a los usuarios cambiar entre pantalla completa o ancho fijo de pantalla.';
$string['events'] = 'Eventos';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Carga el archivo favicon.ico que se muestra en la pestaña del navegador.';
$string['filteradminmessages'] = 'Filtrar Mensajes del Administrador';
$string['filteradminmessagesdesc'] = 'Habilitar la opción de borrar mensajes por el usuario administrador, esto puede reducir los mensajes de sistema que aparecen a los estudiantes';
$string['fontblockheadercolor'] = 'Color de fuente para el encabezado de los bloques';
$string['fontblockheadercolordesc'] = 'Establezca el color de fuente para el encabezado de los bloques, use código html hexadecimal.';
$string['fontblockheadersize'] = 'Tamaño de fuente para el encabezado de los bloques';
$string['fontblockheadersizedesc'] = 'Establezca el tamaño de fuente para el encabezado de los bloques. Seleccione un valor de la lista.';
$string['fontblockheaderweight'] = 'Grosor de fuente para los encabezados de bloques';
$string['fontblockheaderweightdesc'] = 'Establezca el grosor de fuente usado en los encabezados de los bloques. Seleccione un valor entre 100 y 900 dependiendo del tipo de fuente seleccionada.';
$string['fontcolor'] = 'Color de la fuente principal';
$string['fontcolordesc'] = 'Establece el color de la fuente principal.';
$string['fontdesc'] = 'Selecciona la fuente de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> para el texto, los encabezamientos y el título. Selecciona también el juego de caracteres a usar (latín está incluido por defecto) e introduce el valor correcto para el grueso de fuente utilizado o no se mostrará.';
$string['fontheadercolor'] = 'Color de la fuente de encabezamientos';
$string['fontheadercolordesc'] = 'Establece el color de la fuente de los encabezamientos utilizados en la plantilla.';
$string['fontheadername'] = 'Fuente encabezamientos';
$string['fontheadernamedesc'] = 'Establece la fuente de los encabezamientos utilizados en la plantilla. Selecciona default o una fuente de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a>.';
$string['fontheaderweight'] = 'Grueso de la fuente de encabezamientos';
$string['fontheaderweightdesc'] = 'Establece el grueso de la fuente de los encabezamientos. Introducir un valor entre 100 y 900 dependiendo de la fuente utilizada.';
$string['fontname'] = 'Fuente principal';
$string['fontnamedesc'] = 'Establece la fuente principal. Selecciona defecto o una fuente de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a>.';
$string['fontsettings'] = 'Fuentes';
$string['fontsettingsheading'] = 'Establece las fuentes utilizadas por la plantilla.';
$string['fontsize'] = 'Tamaño de la fuente principal';
$string['fontsizedesc'] = 'Selecciona el tamaño de la fuente principal usada en todo el sitio (en porcentaje).';
$string['fontsubset'] = 'Juego de caracteres de Google Fonts';
$string['fontsubsetdesc'] = 'Seleccionar el juego de caracteres de Google Fonts a usar además del latín ya incluido por defecto. Se aplicará a toda las fuentes seleccionadas.';
$string['fonttitlecolor'] = 'Color de la fuente del título del sitio';
$string['fonttitlecolorcourse'] = 'Color de la fuente del título del curso';
$string['fonttitlecolorcoursedesc'] = 'Establece el color de la fuente usada en el título del curso.';
$string['fonttitlecolordesc'] = 'Establece el color de la fuente del título del sitio situado en la cabecera.';
$string['fonttitlename'] = 'Fuente del título del sitio';
$string['fonttitlenamedesc'] = 'Establece la fuente del título del sitio situado en la cabecera. Selecciona default o una fuente de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a>.';
$string['fonttitlesize'] = 'Tamaño de la fuente del título del sitio';
$string['fonttitlesizedesc'] = 'Tamaño de la fuente del título del sitio situado en la cabecera. Introducir un valor decimal, por ejemplo: 24px';
$string['fonttitleweight'] = 'Grueso de la fuente del título del sitio';
$string['fonttitleweightdesc'] = 'Establece el grueso de la fuente del título del sitio. Introducir un valor entre 100 y 900 dependiendo de la fuente utilizada.';
$string['fontweight'] = 'Grueso de la fuente principal';
$string['fontweightdesc'] = 'Establece el grueso de la fuente principal. Introducir un valor entre 100 y 900 dependiendo de la fuente utilizada.';
$string['footerbkcolor'] = 'Color de fondo del pie de página superior';
$string['footerbkcolordesc'] = 'Establece el color de fondo del pie de página superior.';
$string['footerblocksplacement'] = 'Páginas donde mostrar los bloques del pie de página';
$string['footerblocksplacement1'] = 'Todo el sitio';
$string['footerblocksplacement2'] = 'Página Inicial';
$string['footerblocksplacement3'] = 'Nunca';
$string['footerblocksplacementdesc'] = 'Definir los lugares donde se deben mostrar los bloques del pie de página. Todo el sitio es la opción por defecto.';
$string['footercontent'] = 'Contenido del bloque del pie de página';
$string['footercontentdesc'] = 'Añade el código HTML del bloque del pie de página (ver el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para más ejemplos)';
$string['footerdesc'] = 'Añade el titulo del bloque del pie de página';
$string['footerheader'] = 'Titulo del bloque del pie de página';
$string['footerlayoutrow'] = 'Creador de regiones para los bloques del pie de página';
$string['footerlayoutrowdesc'] = 'Utiliza esta opción para ver la distribución creada y comprobar el número de bloques del pie de página que has utilizado.';
$string['footerlinkcolor'] = 'Color de los enlaces del pie de página';
$string['footerlinkcolordesc'] = 'Establece el color de los enlaces del pie de página.';
$string['footersettings'] = 'Pie de Página';
$string['footersettingsheading'] = 'A continuación puedes crear tu propia distribución de regiones para el pie de página.
Para añadir contenido a estas regiones necesitarás <strong>Activar edición en la página principal de Moodle</strong>.
Entonces podrás arrastras y soltar los bloques en las regiones creadas.';
$string['footertextcolor'] = 'Color de texto del pie de página superior';
$string['footertextcolor2'] = 'Color del texto del pie de página inferior';
$string['footertextcolor2desc'] = 'Establece el color del texto del pie de página inferior.';
$string['footertextcolordesc'] = 'Establece el color de texto en el pie de página superior.';
$string['footnote'] = 'Texto del bloque del pie de página';
$string['footnotedesc'] = 'Añade el código HTML del bloque de pie de página (ver el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para más ejemplos)';
$string['frnt-footer'] = 'Los bloques de esta área solo serán visibles para los administradores.';
$string['frontpagealertsettings'] = 'Alertas';
$string['frontpageblockregionsettings'] = 'Creador de regiones para bloques';
$string['frontpageblocksenabled'] = 'Activa las regiones para bloques en la página principal';
$string['frontpageblocksenableddesc'] = 'Activa o desactiva las regiones para bloques de la página principal.
Puedes arrastrar y soltar los bloques en las regiones creadas.';
$string['frontpageblocksettings'] = 'Bloques promocionales';
$string['frontpagecoursesettings'] = 'Cursos';
$string['frontpagedesc'] = 'Configurar la forma en que los cursos son mostrados en la página inicial.';
$string['frontpagelogin'] = 'Formulario de entrada en la cabecera';
$string['frontpagelogindesc'] = 'Mostrar el formulario de entrada en la parte superior de la cabecera. En caso contrario, se mostrará solo el botón.';
$string['frontpagemarketenabled'] = 'Activar los bloques promocionales';
$string['frontpagemarketenableddesc'] = 'Activar los bloques promocionales en la pagina de inicio.';
$string['frontpagemarketoption'] = 'Estilo de los bloques promocionales';
$string['frontpagemarketoptiondesc'] = 'Establecer los bloques promocionales tipo Coventry. Configurar el color de esta opción en la página de colores.';
$string['frontpagerenderer'] = 'Bloques de cursos';
$string['frontpagerendererdefaultimage'] = 'Imagen por defecto para los cursos';
$string['frontpagerendererdefaultimagedesc'] = 'Sube la imagen que se utilizará por defecto en los cursos que no dispongan de ella.  (solo se aplica en el estilo "Bloques Superpuestos")';
$string['frontpagerendererdesc'] = 'Configurar la forma en que los cursos son mostrados en la página inicial.';
$string['frontpagerendereroption1'] = 'Bloques';
$string['frontpagerendereroption2'] = 'Bloques sin incrustar';
$string['frontpagerendereroption3'] = 'Por defecto';
$string['frontpagerendereroption4'] = 'Tipo Coventry';
$string['frontpagesettingsheading'] = 'Página Inicial';
$string['frontpageslidersettings'] = 'Presentación diapositivas';
$string['frontpagetickersettings'] = 'Anuncios';
$string['fullscreen'] = 'Pantalla completa';
$string['fullscreenwidth'] = 'Ancho de pantalla completa';
$string['fullscreenwidthdesc'] = 'Establece el ancho máximo de la pantalla en modo pantalla completa / zoom.';
$string['genericsettingsdescription'] = 'Introduce tu propio código CSS y Javascript.';
$string['genericsettingsheading'] = 'Introduce tu propio código CSS y Javascript';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsdesc'] = 'Puedes añadir múltiples códigos de Google Analytics y enlazarlos a campos de perfíl de usuario.';
$string['googleanalyticssettingsheading'] = 'Configurar Google analytics en tu sitio.';
$string['headerbgimage'] = 'Imagen de fondo';
$string['headerbgimagedesc'] = 'Establezca una imagen de fondo en la cabecera. El tamaño mínimo es 1600 x 180 px (se recomienda 1900 x 180 px). La imagen cubre el encabezado completamente. Puede agregar un color en \'Color de fondo del encabezado superior\' o usar <i> transparente </i> para mostrar la imagen de fondo. En ese caso midifique el color de texto para que se presente correctamente en la imagen.';
$string['headerbkcolor'] = 'Color de fondo de la parte superior de la cabecera';
$string['headerbkcolor2'] = 'Color de fondo de la parte inferior de la cabecera';
$string['headerbkcolor2desc'] = 'Establece el color de fondo de la parte inferior de la cabecera.';
$string['headerbkcolordesc'] = 'Establece el color de fondo de la parte superior de la cabecera.';
$string['headerdesc'] = 'Mostrar Alertas para avisar a los usuarios, controlar la barra de navegación, mostrar el título del sitio o el logo son algunas de las opciones de la cabecera.';
$string['headersettings'] = 'Cabecera';
$string['headersettingsheading'] = 'Personalización de la cabecera.';
$string['headertextcolor'] = 'Color de texto y enlaces de la parte superior de la cabecera';
$string['headertextcolor2'] = 'Color del texto y enlaces de la parte inferior de la cabecera';
$string['headertextcolor2desc'] = 'Establece el color de texto y enlaces de la parte inferior de la cabecera.';
$string['headertextcolordesc'] = 'Establece el color de texto y enlaces de la parte superior de la cabecera.';
$string['help'] = 'Ayuda';
$string['helpprofilefield'] = 'Campo personalizado para la ayuda (opcional)';
$string['helpprofilefielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: usertype=alumno';
$string['helptarget'] = 'Nueva ventana de ayuda';
$string['helptargetdesc'] = 'Abrir la ayuda en la misma ventana o en una nueva.';
$string['helptitle'] = 'Ayuda por perfil';
$string['helptitle2'] = 'Enlace de ayuda dependiente del campo personalizado en el perfil.';
$string['hiddencourses'] = 'Cursos ocultos';
$string['hide'] = 'Ocultar';
$string['hidealertsmobile'] = 'Ocultar Alertas';
$string['hidealertsmobiledesc'] = 'Oculta las alertas de la parte superior de la pantalla (si están activadas)';
$string['hideblocks'] = 'Ocultar bloques';
$string['hidebreadcrumbmobile'] = 'Ocultar ruta de navegación';
$string['hidebreadcrumbmobiledesc'] = 'Oculta la ruta de navegación.';
$string['hidecoursetitlemobile'] = 'Oculta el título del curso';
$string['hidecoursetitlemobiledesc'] = 'Oculta el título del curso y del sitio';
$string['hidefootersocial'] = 'Mostrar iconos sociales';
$string['hidefootersocialdesc'] = 'Mostrar iconos sociales en el pie de página, después de los bloques.';
$string['hideheadermobile'] = 'Ocultar la cabecera';
$string['hideheadermobiledesc'] = 'Oculta la cabecera, logo, iconos sociales y búsqueda.';
$string['hideinforum'] = 'Ocultar Menús de Ayuda y Herramientas en los foros';
$string['hideinforumdesc'] = 'Si se utiliza un ancho fijo de pantalla es posible que los menús salten a la línea inferior. Activando esta opción se ocultan los menús en las páginas de foros.';
$string['hidelogomobile'] = 'Ocultar logo';
$string['hidelogomobiledesc'] = 'Ocultar el logo.';
$string['hidepagefootermobile'] = 'Ocultar pie de página';
$string['hidepagefootermobiledesc'] = 'Oculta el pie de página.';
$string['hideslidermobile'] = 'Ocultar la presentación de diapositivas en dispositivos móviles';
$string['hideslidermobiledesc'] = 'Ocultar eliminará el presentador de diapositivas de la página inicial en dispositivos móviles';
$string['hidesocialmobile'] = 'Ocultar los iconos sociales';
$string['hidesocialmobiledesc'] = 'Oculta los iconos sociales (si están activados)';
$string['homebk'] = 'Imagen de fondo';
$string['homebkdesc'] = 'Carga la imagen de fondo para la plantilla.';
$string['infobox'] = 'Cuadro informativo 1';
$string['infobox2'] = 'Cuadro informativo 2';
$string['infobox2desc'] = 'Añade el código HTML del cuadro informativo 2 (ver el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para más ejemplos)';
$string['infoboxdesc'] = 'Añade el código HTML del cuadro informativo 1 (ver el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para más ejemplos)';
$string['infoboxfullscreen'] = 'Cuadros informativos a ancho completo';
$string['infoboxfullscreendesc'] = 'Marca está opción para mostrar los cuadros informativos a ancho completo de pantalla.';
$string['jssection'] = 'Javascript personalizado';
$string['jssectiondesc'] = 'Introduce el código Javascript personalizado.';
$string['layoutaddcontent'] = 'Añade contenido a los bloques promocionales:';
$string['layoutaddcontentdesc1'] = 'Has configurado';
$string['layoutaddcontentdesc2'] = 'bloques promocionales. Si estás conforme con la distribución añade el contenido de los bloques promocionales.
Si no estás conforme, usa el creador de regiones para bloques promocionales para realizar cambios<br />';
$string['layoutcheck'] = 'Comprueba la distribución';
$string['layoutcheckdesc'] = 'Utiliza esta opción para ver la distribución creada y comprobar el número de bloques que has utilizado.';
$string['layoutcount1'] = 'Puedes crear un máximo de';
$string['layoutcount2'] = 'regiones para bloques. Ahora estás usando:';
$string['layoutdesc'] = 'Configuración de la disposición por defecto.';
$string['layoutmobilesettings'] = 'Configuración móvil';
$string['layoutmobilesettingsdesc'] = 'Configuración especifica para dispositivos móviles.';
$string['layoutsettings'] = 'Disposición';
$string['layoutsettingsheading'] = 'Controlar las diferentes disposiciones de la plantilla.';
$string['leftblocks'] = 'Izquierda';
$string['linkcolor'] = 'Color enlace';
$string['linkcolordesc'] = 'Establece el color de los enlaces.';
$string['linkhover'] = 'Color sobre enlace';
$string['linkhoverdesc'] = 'Establece el color cuando pasa el cursor sobre los enlaces.';
$string['linksmenu'] = 'Menú de enlaces';
$string['loadingcolor'] = 'Color del cargador';
$string['loadingcolordesc'] = 'Color del cargador situado en la parte superior de la página.';
$string['loadtime'] = 'Página cargada en';
$string['loginplaceholder'] = 'Usuario';
$string['logintextbutton'] = 'Entrar';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Sube el archivo con la imagen del logo (170px x 100px max.). Formatos admitidos: .png, .jpg y .gif';
$string['maincolor'] = 'Color principal';
$string['maincolordesc'] = 'Establece el color principal del sitio.';
$string['market'] = 'Bloque promocional';
$string['marketblockbordercolor'] = 'Color del borde de los bloques promocionales';
$string['marketblockbordercolordesc'] = 'Establece el color del borde de los bloques promocionales.';
$string['marketblocksbackgroundcolor'] = 'Color de fondo de la región de los bloques promocionales.';
$string['marketblocksbackgroundcolordesc'] = 'Establece el color de fondo de la región de los bloques promocionales.';
$string['marketdesc'] = 'Añade el código HTML del bloque promocional (ver el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para más ejemplos).';
$string['marketingbuilderdesc'] = 'Utiliza esta opción para ver la distribución creada y comprobar el número de bloques promocionales que has utilizado.';
$string['marketingbuilderheading'] = 'Creador de regiones para bloques promocionales';
$string['marketingdesc'] = 'Dispones de dos cuadros informativos a los que puedes aplicar diferentes estilos. Además puedes activar el creador de regiones
para bloques y decidir cuantos bloques quieres mostrar y su distribución en la página de inicio. Puedes ver la distribución de las diferentes regiones en el archivo  <a href="/adaptable/README.txt" target="_blank">README.txt</a>';
$string['marketingsettings'] = 'Bloques promocionales';
$string['marketingsettingsheading'] = 'Personaliza los bloques promocionales que aparecen en la página de inicio. Ver la distribución <a href="./../theme/adaptable/pix/layout.png" target="_blank">aqui</a>';
$string['marketlayoutrow'] = 'Filas de regiones para bloques promocionales';
$string['marketlayoutrowdesc'] = 'Añade / establece la distribución de filas de las regiones para bloques promocionales de la página principal.';
$string['menubkcolor'] = 'Color de fondo del menú principal';
$string['menubkcolordesc'] = 'Establece el color de fondo del menú principal.';
$string['menubordercolor'] = 'Color de la línea divisoria de la barra de navegación';
$string['menubordercolordesc'] = 'Establece el color de la linea divisoria de la barra de navegación.';
$string['menufontcolor'] = 'Color de texto del menú principal';
$string['menufontcolordesc'] = 'Establece el color del texto del menú principal.';
$string['menufontpadding'] = 'Separación entre los ítems de la barra de navegación';
$string['menufontpaddingdesc'] = 'Establece la separación entre los ítems de la barra de navegación.';
$string['menufontsize'] = 'Tamaño de fuente de la barra de navegación';
$string['menufontsizedesc'] = 'Establece el tamaño de fuente de la barra de navegación.';
$string['menuhovercolor'] = 'Color hover del menú principal';
$string['menuhovercolordesc'] = 'Establece el color hover delú men principal';
$string['menuoverrideprofilefield'] = 'Nombre del campo personalizado';
$string['menuoverrideprofilefielddefault'] = 'topmenusettings';
$string['menuoverrideprofilefielddesc'] = 'El nombre del campo de perfil "list" usado por la anulación por usuario.';
$string['menusdesc'] = '';
$string['menusession'] = 'Almacenar los detalles de acceso en la sesión';
$string['menusessiondesc'] = 'Se aconseja activar esta opción para optimizar el rendimiento en caso de utilizar varios menús. Mantener desactivado para pruebas.';
$string['menusessionttl'] = 'Tiempo (minutos) de almacenamiento del acceso a los menús por sesión';
$string['menusessionttldesc'] = 'Número de minutos antes de reiniciar la sesión.';
$string['menusettings'] = 'Menús de cabecera';
$string['menusettingsheading'] = 'Personaliza los menús de la cabecera superior.';
$string['menusheading'] = 'Configurar Navegación para los menús de la parte superior de la cabecera';
$string['menusheadingvisibility'] = 'Configuración para la visibilidad del menú superior';
$string['menusheadingvisibilitydesc'] = 'La siguiente configuración permite controlar donde mostrar los menús y opcionalmente permitir a los usuarios su personalización.';
$string['menuslinkright'] = 'Mostrar el menú de enlaces en la parte superior derecha';
$string['menuslinkrightdesc'] = 'Si está seleccionado, se mostrará el enlace a los menús en la parte superior derecha, junto al menú de mensajes';
$string['menustitledesc'] = 'Los menús de herramientas (en la barra de navegación) y los menús superiores (cabecera superior) pueden ser restringidos dependiendo de un campo personalizado del perfil de usuario (opcional). Los menús siguen el formato de los menús estándar de moodle:
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
Moodle.com|http://moodle.com/
</pre>';
$string['menuuseroverride'] = 'Permitir la anulación por usuario';
$string['menuuseroverridedesc'] = 'Esta configuración controla el uso de los menús a través del perfil de usuario. Para usar esta función, se ha de crear un campo personalizado de usuario tipo lista con los siguientes valores:
<pre>1. Sitewide (mostrará el menú en todo el sitio)
2. Homepages Only (mostrará el menú solo en la página principal)
3. Hidden (no se mostrarán los menús)</pre>
NO debes utilizar la opción "Desactivar menús en las páginas de los cursos" junto a los campos de perfil. En su lugar, selecciona  "Homepages Only".

Nota: Los usuarios deberán salir de moodle y volver a entrar para que los cambios hagan efecto. Puede indicarse una nota al crear el campo personalizado.';
$string['messagepopupbackground'] = 'Color de fondo para mensajes emergentes.';
$string['messagepopupbackgrounddesc'] = 'Establezca el color de fondo para los mensajes emergentes.';
$string['messagepopupcolor'] = 'Color de texto para mensajes emergentes.';
$string['messagepopupcolordesc'] = 'Establezca el color de texto para los mensajes emergentes.';
$string['mobilemenubkcolor'] = 'Color de fondo del menú para móvil';
$string['mobilemenubkcolordesc'] = 'Establece el color de fondo del menú principal en móviles (colapsado)';
$string['mobilemenufontcolor'] = 'Color del texto del menú para móvil';
$string['mobilemenufontcolordesc'] = 'Establece el color de texto del menú principal en móviles (colapsado)';
$string['mobilesettings'] = 'Configuración para dispositivos móviles';
$string['mobilesettingsheading'] = 'Configura la plantilla para ser visualizada en dispositivos móviles.';
$string['moodledocs'] = 'Mostrar enlace a Moodle Docs';
$string['moodledocsdesc'] = 'Mostrar un enlace a Moodle Docs en el pie de página.';
$string['msgbadgecolor'] = 'Color de fondo del marcador de mensajes.';
$string['msgbadgecolordesc'] = 'Establece el color de fondo del marcador de mensajes en la cabecera (donde se muestra el número de mensajes no leidos)';
$string['myblogs'] = 'Mis Blogs';
$string['mycoursesmenulimit'] = 'Límite del menú Mis Cursos';
$string['mycoursesmenulimitdesc'] = 'Ajuste el número máximo de cursos que aparecerán en el menú Mis Cursos. 0 mostrará todos los cursos.';
$string['mysites'] = 'Mis Cursos';
$string['mysitesdisabled'] = 'Desactivado';
$string['mysitesexclude'] = 'Mostrar excluyendo los cursos ocultos';
$string['mysitesinclude'] = 'Mostrar incluyendo los cursos ocultos';
$string['mysitesmaxlength'] = 'Longitud máxima del título del curso en "Mis Cursos"';
$string['mysitesmaxlengthdesc'] = 'Ajusta la longitud máxima del título del curso a mostrar en "Mis Cursos". La longitud dependerá del tamaño y de la fuente usada.';
$string['mysitessortoverride'] = 'Activar el orden personalizado de "Mis Cursos"';
$string['mysitessortoverridedesc'] = 'Usa campos personalizados o textos (año, edad, ...) para colapsar los cursos en un desplegable.';
$string['mysitessortoverridefield'] = 'Campo personalizado o texto para filtrar "Mis Cursos"';
$string['mysitessortoverridefielddesc'] = 'Lista con delimitación por comas de los campos o textos a comprobar en el nombre corto de curso.';
$string['mysitessortoverrideoff'] = 'Mostrar lista de cursos.';
$string['mysitessortoverrideprofilefields'] = 'Muestra los cursos coincidentes con un campo personalizado en una lista. El resto son mostrados en un submenú.';
$string['mysitessortoverrideprofilefieldscohort'] = 'Muestra los cursos coincidentes con un campo de perfil y los cohortes en primer lugar. El resto son mostrados en un submenú.';
$string['mysitessortoverridestrings'] = 'Muestra todos los cursos en los que está matriculado el alumno en una lista. El resto son mostrados en un submenú.';
$string['navbarcachetime'] = 'Caché de la barra de navegación';
$string['navbarcachetimedesc'] = 'El tiempo, en minutos, que se guarda la barra de navegación.';
$string['navbardesc'] = 'Controlar los diferentes elementos a mostrar en la barra de navegación.';
$string['navbarmenusettings'] = 'Menú Navegación';
$string['navbarmenusettingsdesc'] = 'Añadir menús en la barra de navegación.';
$string['navbarmenusettingsheading'] = 'Personalizar el menú de la barra de navegación';
$string['navbarsettings'] = 'Barra de navegación';
$string['navbarsettingsheading'] = 'Personalizar la barra de navegación';
$string['newmenu'] = 'Menú superior desplegable';
$string['newmenu1trigger'] = 'Palabra clave para el Menú desplegable superior';
$string['newmenu1triggerdesc'] = 'Establece una palabra clave para el Menú desplegable superior. Puedes utilizar los iconos de Font Awesome.';
$string['newmenu2trigger'] = 'Palabra clave para el Menú desplegable superior';
$string['newmenu2triggerdesc'] = 'Establece la palabra clave para el Menú desplegable superior.';
$string['newmenudesc'] = 'Configurar los enlaces mostrados bajo el menú de la cabecera superior.';
$string['newmenufield'] = 'Nombre del campo personalizado del perfíl Field Name=Value (opcional)';
$string['newmenufielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: usertype=alumno';
$string['newmenuheading'] = 'Menú superior';
$string['newmenurequirelogin'] = 'Requiere Entrar';
$string['newmenurequirelogindesc'] = 'Si está activado este menú será visible a los usuarios que autenticados';
$string['newmenutitle'] = 'Título menú superior';
$string['newmenutitledefault'] = 'Menú';
$string['newmenutitledesc'] = 'El título del menú aparecerá en la cabecera del sitio';
$string['newstickercount'] = 'Número de barras de anuncios';
$string['newstickercountdesc'] = 'Define barras de anuncios con diferentes reglas de acceso para mostrarlas a diferentes tipos de usuarios.';
$string['nextsection'] = 'Siguiente sección';
$string['noenrolments'] = 'No hay matriculaciones.';
$string['nostyle'] = 'Sin estilo';
$string['pageheaderheight'] = 'Altura de la cabecera';
$string['pageheaderheightdesc'] = 'Establece la altura de la cabecera (incluyendo logo y títulos)';
$string['passwordplaceholder'] = 'Contraseña';
$string['pastcourses'] = 'Cursos anteriores';
$string['people'] = 'Gente';
$string['piwikenabled'] = 'Activado';
$string['piwikenableddesc'] = 'Activar Piwik';
$string['piwikimagetrack'] = 'Imagen de rastreo';
$string['piwikimagetrackdesc'] = 'Activa la imagen de rastreo para navegadores que no tengan habilitado JavaScript';
$string['piwiksettings'] = 'Piwik';
$string['piwiksettingsdesc'] = 'Generar una URL limpia para rastreo avanzado.';
$string['piwiksettingsheading'] = 'Configurar Piwik';
$string['piwiksiteid'] = 'ID del sitio';
$string['piwiksiteiddesc'] = 'Introducir la ID del sitio.';
$string['piwiksiteurl'] = 'URL de Piwik';
$string['piwiksiteurldesc'] = 'Introduce la URL donde esát instalado Piwik sin http(s) ni barra invertida.';
$string['piwiktrackadmin'] = 'Rastreo de administradores';
$string['piwiktrackadmindesc'] = 'Activar el rastreo de administradores (no recomendado)';
$string['pluginname'] = 'Adaptable';
$string['previoussection'] = 'Sección anterior';
$string['privacy:metadata'] = 'Adaptable no almacena datos de usuario individuales.';
$string['region-frnt-footer'] = 'Pie';
$string['region-frnt-market-a'] = 'Marketing-a';
$string['region-frnt-market-b'] = 'Marketing-b';
$string['region-frnt-market-c'] = 'Marketing-c';
$string['region-frnt-market-d'] = 'Marketing-d';
$string['region-frnt-market-e'] = 'Marketing-e';
$string['region-frnt-market-f'] = 'Marketing-f';
$string['region-frnt-market-g'] = 'Marketing-g';
$string['region-frnt-market-h'] = 'Marketing-h';
$string['region-frnt-market-i'] = 'Marketing-i';
$string['region-frnt-market-j'] = 'Marketing-j';
$string['region-frnt-market-k'] = 'Marketing-k';
$string['region-frnt-market-l'] = 'Marketing-l';
$string['region-frnt-market-m'] = 'Marketing-m';
$string['region-frnt-market-n'] = 'Marketing-n';
$string['region-frnt-market-o'] = 'Marketing-o';
$string['region-frnt-market-p'] = 'Marketing-p';
$string['region-frnt-market-q'] = 'Marketing-q';
$string['region-frnt-market-r'] = 'Marketing-r';
$string['region-frnt-market-s'] = 'Marketing-s';
$string['region-frnt-market-t'] = 'Marketing-t';
$string['regionmaincolor'] = 'Color de la región principal';
$string['regionmaincolordesc'] = 'Establece el color de fondo de la región principal.';
$string['region-middle'] = 'Centro';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['rendereroverlaycolor'] = 'Color superpuesto';
$string['rendereroverlaycolordesc'] = 'El color superpuesto sobre el bloque de curso cuando "Bloques Superpuestos" está seleccionado.';
$string['rendereroverlayfontcolor'] = 'Color de texto en la superposición';
$string['rendereroverlayfontcolordesc'] = 'El color de la fuente cuando pasa el cursor por encima del bloque del curso y "Bloques Superpuestos" está activado.';
$string['rightblocks'] = 'Derecha';
$string['searchcourses'] = 'Buscar Cursos';
$string['sectionheadingcolor'] = 'Color de fondo de la cabecera de sección';
$string['sectionheadingcolordesc'] = 'Establece el color de fondo de la cabecera del tema actual.';
$string['selectionbackground'] = 'Color de fondo de la selección';
$string['selectionbackgrounddesc'] = 'Establece el color de fondo del texto seleccionado.';
$string['selectiontext'] = 'Color de texto de la selección';
$string['selectiontextdesc'] = 'Establece el color del texto seleccionado';
$string['settingsalertbox'] = 'Alertas';
$string['settingsanalytics'] = 'Estadísticas';
$string['settingsborders'] = 'Bordes';
$string['settingsbreadcrumbcolors'] = 'Colores de la ruta de navegación';
$string['settingscolors'] = 'Colores';
$string['settingsfonts'] = 'Fuentes';
$string['settingsfootercolors'] = 'Colores del pie de página';
$string['settingsheadercolors'] = 'Colores cabecera';
$string['settingsinfoboxcolors'] = 'Colores cuadro informativo principal';
$string['settingsmaincolors'] = 'Colores principales';
$string['settingsmarketingcolors'] = 'Colores bloques moodle';
$string['settingsmenucolors'] = 'Colores menú';
$string['settingsmessagescolors'] = 'Colores para los mensajes emergentes';
$string['settingsmobilemenucolors'] = 'Colores menú móvil';
$string['settingsnavbarcolors'] = 'Colores de la barra de navegación';
$string['settingsoverlaycolors'] = 'Colores bloques cursos';
$string['settingssecondinfoboxcolors'] = 'Colores cuadro informativo secundario';
$string['settingstopicsweeks'] = 'Temas / Semanas';
$string['show'] = 'Mostrar';
$string['showblocks'] = 'Mostrar bloques';
$string['showfooterblocks'] = 'Mostrar bloques en el pie de página';
$string['showfooterblocksdesc'] = 'Mostrar / Ocultar los bloques personalizables del pie de página.';
$string['sitetitle'] = 'Mostrar título del sitio';
$string['sitetitlecoursesdisabled'] = 'Desactivado - muestra solo el título del curso en las páginas del curso';
$string['sitetitlecoursesenabled'] = 'Activado - muestra el nombre del sitio y el título del cursos en las páginas del curso';
$string['sitetitlecustom'] = 'Usar nombre del sitio personalizado (introducir el texto en el siguiente campo)';
$string['sitetitledefault'] = 'Usar el nombre del sitio Moodle';
$string['sitetitledesc'] = 'Mostrar / Ocultar el título del sitio.
Muestra el titulo del sitio moodle por defecto introducido en <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Ajustes de Portada</a> o introduce un texto en la caja inferior. Si se añade una imagen para el logotipo entonces no se mostrará.';
$string['sitetitlemaxwidth'] = 'Longitud máxima del nombre del sitio';
$string['sitetitlemaxwidthdesc'] = 'Establece la longitud máxima de caracteres del nombre del sitio. La longitud final dependerá de la fuente, tamaño y resolución de pantalla.';
$string['sitetitleoff'] = 'Desactivar el nombre del sitio';
$string['sitetitlepaddingleft'] = 'Separación izquierda del nombre del sitio';
$string['sitetitlepaddingleftdesc'] = 'Permite ajustar la separación, en píxeles, de la parte izquierda del nombre del sitio.';
$string['sitetitlepaddingtop'] = 'Separación superior del nombre del sitio';
$string['sitetitlepaddingtopdesc'] = 'Permite ajustar la separación, en píxeles, de la parte superior del nombre del sitio.';
$string['sitetitletext'] = 'Nombre del sitio';
$string['sitetitletextdesc'] = 'Introducir el nombre del sitio que se mostrará en la cabecera. Se puede utilizar cualquier etiqueta HTML y aplicar estilos en linea.';
$string['slider2h3bgcolor'] = 'Color de fondo H3 del estilo de presentación 2';
$string['slider2h3bgcolordesc'] = 'Establece el color de fondo de la etiqueta H3 cuando se utiliza el estilo de presentación 2.';
$string['slider2h3color'] = 'Color del texto H3 del estilo de presentación 2';
$string['slider2h3colordesc'] = 'Establece el color del texto de la etiqueta H3 cuando se utiliza el estilo de presentación 2.';
$string['slider2h4bgcolor'] = 'Color de fondo H4 del estilo de presentación 2';
$string['slider2h4bgcolordesc'] = 'Establece el color de fondo de la etiqueta H4 cuando se utiliza el estilo de presentación 2.';
$string['slider2h4color'] = 'Color del texto H4 del estilo de presentación 2';
$string['slider2h4colordesc'] = 'Establece el color del texto de la etiqueta H4 cuando se utiliza el estilo de presentación 2.';
$string['slidercaption'] = 'Texto de la diapositiva';
$string['slidercaptiondesc'] = 'Añade un texto a la diapositiva.';
$string['slidercount'] = 'Número de dispositivas';
$string['slidercountdesc'] = 'Establece el número de diapositivas a mostrar en la página principal y <strong>haz clic en Guardar</strong> para introducir la información del resto de campos.';
$string['sliderenabled'] = 'Activar la presentación de diapositivas';
$string['sliderenableddesc'] = 'Activa la presentación de diapositivas en la página principal.';
$string['sliderfullscreen'] = 'Presentación de diapositivas en ancho completo';
$string['sliderfullscreendesc'] = 'Muestra la presentación de diapositivas en todo el ancho de la pantalla.';
$string['sliderh3color'] = 'Color del texto H3 del estilo de presentación 1';
$string['sliderh3colordesc'] = 'Establece el color del texto de la etiqueta H3 cuando se utiliza el estilo de presentación 1.';
$string['sliderh4color'] = 'Color del texto H4 del estilo de presentación 1';
$string['sliderh4colordesc'] = 'Establece el color del texto de la etiqueta H4 cuando se utiliza el estilo de presentación 1.';
$string['sliderimage'] = 'Imagen de la diapositiva';
$string['sliderimagedesc'] = 'Añade una imagen a la diapositiva.';
$string['slidermarginbottom'] = 'Margen inferior de la presentación de diapositivas';
$string['slidermarginbottomdesc'] = 'Establece el margen inferior de la presentación de diapositivas.';
$string['slidermargintop'] = 'Margen superior de la presentación de diapositivas';
$string['slidermargintopdesc'] = 'Establece el margen superior de la presentación de diapositivas.';
$string['slideroption2'] = 'Seleccionar tipo de presentación de diapositivas';
$string['slideroption2a'] = 'Color de fondo de las flechas de la presentación de diapositivas tipo 2';
$string['slideroption2adesc'] = 'Establece el color de fondo de las flechas de la presentación de diapositivas cuando se utiliza el estilo de presentación 2.';
$string['slideroption2color'] = 'Color de fondo de la presentación de diapositivas tipo 2';
$string['slideroption2colordesc'] = 'Establece el color de fondo de la diapositiva cuando se utiliza el estilo de presentación 2.';
$string['slideroption2desc'] = 'Selecciona el tipo de presentación de diapositivas <strong>y pulsar Guardar</strong>para mostrar los colores del estilo seleccionado.';
$string['slideroption2snippet'] = '<p>Ejemplo HTML para el texto de las diapositivas:</p>
<pre>
&#x3C;div class=&#x22;span6 col-sm-6&#x22;&#x3E;
&#x3C;h3&#x3E;Hecho a mano&#x3C;/h3&#x3E; &#x3C;h4&#x3E;pixels y código para la comunidad Moodle&#x3C;/h4&#x3E;
&#x3C;a href=&#x22;#&#x22; class=&#x22;submit&#x22;&#x3E;Por favor, haz Adaptable uno de tus temas favoritos&#x3C;/a&#x3E;
</pre>';
$string['slideroption2submitcolor'] = 'Color de fondo del enlace del estilo de presentación 2';
$string['slideroption2submitcolordesc'] = 'Establece el color de fondo del texto del enlace cuando se utiliza el estilo de presentación 2.';
$string['sliderstyle1'] = 'Pase de diapositivas estilo 1';
$string['sliderstyle2'] = 'Pase de diapositivas estilo 2';
$string['slidersubmitbgcolor'] = 'Color del botón del estilo de presentación 1';
$string['slidersubmitbgcolordesc'] = 'Establece el color del botón cuando se utiliza el estilo de presentación 1.';
$string['slidersubmitcolor'] = 'Color del texto del botón del estilo de presentación 1';
$string['slidersubmitcolordesc'] = 'Establece el color del texto del botón cuando se utiliza el estilo de presentación 1.';
$string['sliderurl'] = 'URL de la diapositiva';
$string['sliderurldesc'] = 'Añade una URL a enlazar desde la diapositiva.';
$string['slideshowdesc'] = 'Sube imágenes, añade enlaces y descripciones en las dispositivas de la presentación de la página de inicio.';
$string['slideshowsettings'] = 'Presentación de diapositivas';
$string['slideshowsettingsheading'] = 'Personaliza la presentación de diapositivas de la página de inicio';
$string['socialboxpaddingbottommobile'] = 'Establece la separación superior del bloque de iconos sociales';
$string['socialboxpaddingtopmobile'] = 'Separación superior del bloque de iconos sociales';
$string['socialheading'] = 'Configuración de los iconos de redes sociales';
$string['socialicondesc'] = 'Selecciona el icono de Font Awesome. Por ejemplo: fa-facebook';
$string['socialiconlist'] = 'Lista de iconos sociales';
$string['socialiconlistdesc'] = 'Introducir una lista delimitada por comas para configurar los iconos de redes sociales que necesites usando el formato: url|titulo|icono';
$string['socialorsearch'] = 'Mostrar cuadro de búsqueda o iconos sociales';
$string['socialorsearchdesc'] = 'Puedes mostrar los iconos sociales o el cuadro de búsqueda en la cabecera. <br />
    <strong>Puedes configurar los iconos sociales en la sección "Redes sociales"</strong>.';
$string['socialorsearchsearch'] = 'Mostrar cuadro de búsqueda';
$string['socialorsearchsocial'] = 'Nostrar iconos de redes sociales';
$string['socialpaddingtop'] = 'Ajustar la separación debajo los iconos sociales (altera la posición vertical)';
$string['socialsearchicon'] = 'Buscar en Moodle';
$string['socialsearchicondesc'] = 'Muestra el cuadro de búsqueda al lado de los iconos sociales.';
$string['socialsettings'] = 'Redes sociales';
$string['socialsize'] = 'Configurar tamaño de los iconos sociales';
$string['socialsizemobile'] = 'Configurar tamaño de los iconos sociales en móviles';
$string['socialtarget'] = 'Formato de apertura de la ventana de enlaces sociales';
$string['socialtargetdesc'] = 'Abrir la red social en la misma venta o en una nueva';
$string['socialtitledesc'] = '<pre>Puedes desactivar la búsqueda y activar los iconos de redes sociales en su lugar.
Para configurar los iconos, introduce una lista delimitada en el campo "Lista de iconos sociales".
El formato debe ser:

url|titulo|icono

Ejemplo:

http://localhost/moodle/course/search.php|Buscar en Moodle|fa-search
http://facebook.com/|Facebook|fa-facebook-square
http://twitter.com/|Twitter|fa-twitter-square
http://instagram.com|Instagram|fa-instagram
http://example.com|Mi Web|fa-globe

El listado de iconos se encuentra en: <a href="http://fortawesome.github.io/Font-Awesome/icons">http://fortawesome.github.io/Font-Awesome/icons</a>Font-Awesome</pre>';
$string['socialwall'] = 'Formato Social Wall';
$string['socialwallactionlinkcolor'] = 'Color de los enlaces de acción';
$string['socialwallactionlinkcolordesc'] = 'Establece el color de los enlaces de acción.';
$string['socialwallactionlinkhovercolor'] = 'Color hover de los enlaces de acción';
$string['socialwallactionlinkhovercolordesc'] = 'Establece el color hover de los enlaces de acción.';
$string['socialwallbackgroundcolor'] = 'Color de fondo';
$string['socialwallbackgroundcolordesc'] = 'Establece el color de fondo.';
$string['socialwallbordercolor'] = 'Color del borde';
$string['socialwallbordercolordesc'] = 'Establece el color del borde de las secciones.';
$string['socialwallbordertopstyle'] = 'Estilo del borde';
$string['socialwallbordertopstyledesc'] = 'Establece el estilo del borde de las secciones.';
$string['socialwallborderwidth'] = 'Grueso del borde';
$string['socialwallborderwidthdesc'] = 'Establece el grueso del borde de las secciones.';
$string['socialwalldesc'] = 'Personaliza el estilo del <a href="https://moodle.org/plugins/format_socialwall">Formato de curso SocialWall</a> (si se utiliza en el sitio)';
$string['socialwallheading'] = 'Formato Social Wall';
$string['socialwallsectionradius'] = 'Radio del borde';
$string['socialwallsectionradiusdesc'] = 'Establece el borde del radio de las secciones.';
$string['standardview'] = 'Vista estándar';
$string['stickynavbar'] = 'Fijar la barra de navegación';
$string['stickynavbardesc'] = 'Fijar la barra de navegación a la parte superior de la página.';
$string['targetnewwindow'] = 'Nueva ventana';
$string['targetsamewindow'] = 'Misma ventana';
$string['thiscourse'] = 'Este curso';
$string['ticker'] = 'Anuncios';
$string['tickerdefault'] = 'No hay anuncios para mostrar';
$string['tickerdesc'] = 'Aquí puedes configurar los anuncios de la página de inicio de tu moodle.
    Solo debes introducir una lista tipo HTML e incluir enlaces.
    Nota: No debes añadir etiquetas ul en la lista, solo li. Los editores de Moodle tienden a añadir etiquetas ul en las listas.
    Si no funciona correctamente, cambia a modo HTML y comprueba que solo hay etiquetas li:
    <pre>
    &lt;li&gt;Anuncio 1.....&lt;/li&gt;
    &lt;li&gt;Anuncio 2.....&lt;/li&gt;
    </pre>
    <br>
    Puedes controlar diferentes secciones de anuncios dependiendo de un campo de perfil de usuario personalizado y así mostrar diferentes anuncios a diferentes perfiles.';
$string['tickersettings'] = 'Anuncios';
$string['tickersettingsheading'] = 'Configura los anuncios de la página de inicio. Ver posición <a href="./adaptable/pix/layout.png" target="_blank"> aquí</a>';
$string['tickertext'] = 'Texto de la barra de anuncios';
$string['tickertext1'] = 'Texto Anuncios 1';
$string['tickertext1desc'] = 'Añadir los anuncios en formato de lista HTML. Ver <a href="adaptable/README.txt">README.txt</a> para más información.';
$string['tickertext2'] = 'Texto Anuncios 2';
$string['tickertext2desc'] = 'Añadir los anuncios en formato de lista HTML para un segundo tipo de usuario. Ver <a href="adaptable/README.txt">README.txt</a> para más información.';
$string['tickertextdesc'] = 'Añade el texto a mostrar en la barra de anuncios en formato de lista. Ver el archivo <a href="adaptable/README.txt">README.txt</a> para más información.';
$string['tickertextprofilefield'] = 'Nombre del campo personalizado del perfíl Field Name=Value (opcional)';
$string['tickertextprofilefielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: "usertype=alumno"';
$string['tickerwidth'] = 'Ancho de la barra de anuncios';
$string['tickerwidthdesc'] = 'Usa este valor para cambiar el ancho de la barra de anuncios al 100%.';
$string['tilesbordercolor'] = 'Color del borde de los bloques de cursos';
$string['tilesbordercolordesc'] = 'establece el color del borde de los bloques de cursos.';
$string['tilescontactstitle'] = 'Mostrar el rol de los contactos del curso';
$string['tilescontactstitledesc'] = 'Muestra / Oculta el rol del contacto en el curso. Si no se muestra, se mostrará una imagen para cada contacto.';
$string['tilesshowallcontacts'] = 'Mostrar todos los contactos del curso';
$string['tilesshowallcontactsdesc'] = 'Muestra todos los contactos del curso o solo el principal.';
$string['tilesshowcontacts'] = 'Mostrar los contactos del curso';
$string['tilesshowcontactsdesc'] = 'Muestra / Oculta los contactos del curso.';
$string['toolsmenu'] = 'Menú de herramientas desplegable';
$string['toolsmenu2'] = '2º Menu Herramientas';
$string['toolsmenu2desc'] = 'Puedes configurar los items de los menús de herramientas. Cada línea consiste en: titulo del item, enlace  (opcional), indicador de función (opcional) y el código de idioma o una lista de códigos separada por comas (opcional, para mostrar el item dependiendo del idioma del usuario) separado por una linea vertical (|). También pueden añadirse sub-items usando guiones. Por ejemplo:
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--Moodle Docs en español|http://docs.moodle.org/es|Documentación en español|es
Moodle.com|http://moodle.com/
</pre>';
$string['toolsmenudesc'] = 'Añade un menú desplegable en la barra de navegación.';
$string['toolsmenufield'] = 'Nombre del campo personalizado del perfíl Field Name=Value (opcional)';
$string['toolsmenufielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: usertype=student';
$string['toolsmenuheading'] = 'Menús herramientas (en la barra de navegación)';
$string['toolsmenuheadingdesc'] = 'Puedes configurar los enlaces a mostrar en el menú de herramientas (en la barra de navegación).
 este formato es similar al usado por los menús personalizados de moodle pero permite añadir los iconos Font Awesome:
<pre>
&lt;span class=&quot;fa fa-video-camera&quot;&gt;&lt;/span&gt; Record Screen|http://google.co.uk|Record Screen
&lt;span class=&quot;fa fa-picture-o&quot;&gt;&lt;/span&gt; ThinkStock|http://google.co.uk|ThinkStock
&lt;span class=&quot;fa fa-clock-o&quot;&gt;&lt;/span&gt; Exam Clock|http://google.co.uk|Exam Clock
</pre><br />';
$string['toolsmenulabel'] = 'Menú Herramientas';
$string['toolsmenulabel2'] = 'Herramientas 2';
$string['toolsmenuscount'] = 'Número de menús de herramientas';
$string['toolsmenuscountdesc'] = 'Establece el número de menús de herramientas que quieres a la barra de navegación.';
$string['toolsmenutitle'] = 'Título menú de herramientas';
$string['toolsmenutitledefault'] = 'Herramientas';
$string['toolsmenutitledesc'] = 'Añade el título a mostrar en la barra de navegación.';
$string['topicsweeks'] = 'Formato de curso Temas/Semanas';
$string['topicsweeksdesc'] = 'Establecer estilos para el formato de curso Temas/Semanas';
$string['topmenufontsize'] = 'Tamaño fuente menú superior';
$string['topmenufontsizedesc'] = 'Establece el tamaño de la fuente usada en el menú superior.';
$string['topmenuscount'] = 'Número de menús superiores';
$string['topmenuscountdesc'] = 'Establece el número de menús superiores que quieres añadir en la cabecera.';
$string['usernav'] = 'Barra de usuario';
$string['usernavdesc'] = 'Permite personalizar los elementos que aparecen Allows you to control all of the elements that appear in the user navigation dropdown.';
$string['usernavheading'] = 'Personalizar el menu de usuario';
$string['viewselect'] = 'Pantalla completa como vista por defecto';
$string['viewselectdesc'] = 'Establecer la vista por defecto a pantalla completa (cuando la opción zoom está activada)';
