<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_aardvark', language 'es', branch 'MOODLE_33_STABLE'
 *
 * @package   theme_aardvark
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['android'] = 'URL de Google Play Store';
$string['androiddesc'] = 'Escriba la URL de su página de Google Play Store (por ejemplo: https://play.google.com/store/apps/developer?id=mycollege)';
$string['apple'] = 'URL de Apple App Store';
$string['appledesc'] = 'Introduzca la URL de su página en la Apple App Store. (algo como https://itunes.apple.com/gb/artist/my-college/id123456789)';
$string['basicheading'] = 'Ajustes básicos';
$string['basicheadingdesc'] = 'Personalizar elementos básicos del tema.';
$string['ceop'] = 'CEOP';
$string['ceopaus'] = 'Habilitar Australia';
$string['ceopdesc'] = 'Habilitar informes CEOP';
$string['ceopnone'] = 'Desactivar';
$string['ceopuk'] = 'Habilitar Reino Unido';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Aardvark</h2>
<p><img class=img-polaroid src="aardvark/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>About</h3>
<p>Aardvark es el tema original basado en menús para Moodle.</p>
<p>Aardvark ha evolucionado con el paso de los años a la vez que el núcleo de Moodle ha ido integrando las características que han hecho a Aardvark tan popular, incluyendo los menús personalizados y de usuario. </p>
<p>El tema cuenta con un aspecto simple inspirado en Flat UI y en material de diseño de Google.</p>
<h3>Padres</h3>
<p>Muchos de los elementos básicos de este tema se basan en Bootstrap y Clean.</p>
<h3>Créditos</h3>
<p>Autor: Shaun Daubney (Newbury College)<br>
Con contribuciones y código base de Bas Brands, David Scotson, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.<br>
Sitio web: <a href="www.newbury-college.ac.uk">Newbury College</a>
</p>
<h3>Informar de un error:</h3>
<p><a href="https://moodle.org/plugins/view.php?plugin=theme_aardvark">https://moodle.org/plugins/view.php?plugin=theme_aardvark</a></p>
<h3>Más información</h3>
<p><a href="aardvark/README.txt">Registro de cambios, licencias e información de versión</a></p>
</div></div>';
$string['configtitle'] = 'Aardvark';
$string['copyright'] = 'Copyright';
$string['copyrightdesc'] = 'El nombre de su organización.';
$string['copyrightlink'] = 'Enlace de Copyright';
$string['copyrightlinkdesc'] = 'La URL del sitio principal de su organización (algo como http://www.mycollege.ac.uk).';
$string['credit'] = 'Basado en un tema original creado por Shaun Daubney';
$string['customcss'] = 'Personalizar CSS';
$string['customcssdesc'] = 'Las reglas CSS que añada en este área de texto se reflejarán en todas las páginas, haciendo más sencilla la personalización de este tema.';
$string['customfooter'] = 'Pie de página por defecto';
$string['customfooterdesc'] = 'El contenido de este área de texto se mostrará en la primera parte/zona del pié de página de todas las páginas.';
$string['disclaimer'] = 'Renuncia';
$string['disclaimerdesc'] = 'El contenido de este área de texto se mostrará en la segunda parte/zona del pié de página de todas las páginas.';
$string['facebook'] = 'URL de Facebook';
$string['facebookdesc'] = 'Introduzca la URL de su página de Facebook. (algo como http://www.facebook.com/mycollege)';
$string['flickr'] = 'URL de Flickr';
$string['flickrdesc'] = 'Introduzca la URL de su página de Flickr. (algo como http://www.flickr.com/mycollege)';
$string['footeroptdesc'] = 'Personalice los elementos básicos del pie de página del tema.';
$string['footeroptheading'] = 'Pie de página';
$string['frontpageheading'] = 'Primera página';
$string['frontpageheadingdesc'] = 'Customice los elementos de la primera página como las alertas de usuario y la fecha.';
$string['generalalert'] = 'Alerta general';
$string['generalalertdesc'] = 'Esto mostrará una alerta en la primera página para avisar a los usuarios de un/a evento/situación en particular.';
$string['googleplus'] = 'URL de Google+';
$string['googleplusdesc'] = 'Introduzca la URL de su perfil de Google+. (algo como http://plus.google.com/107817105228930159735)';
$string['instagram'] = 'URL de Instagram';
$string['instagramdesc'] = 'Introduzca la URL de su página de Instagram (a través de web.stagram). (algo como https://www.instagram.com/mycollege/)';
