<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Privacy Subsystem implementation for block_common_courses.
 *
 * @package    mod_jitsi
 * @copyright  2019 Sergio Comerón Sánchez-Paniagua <sergiocomeron@icloud.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace mod_jitsi\privacy;

use core_privacy\local\metadata\collection;

class provider implements \core_privacy\local\metadata\provider, \core_privacy\local\request\data_provider {

    public static function get_metadata(collection $collection) : collection {
        $collection->add_external_location_link('jitsi', [
            'username' => 'privacy:metadata:jitsi:username',
            'avatar' => 'privacy:metadata:jitsi:avatar',
            ], 'privacy:metadata:jitsi');

        return $collection;
    }
 }
